/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsBeamSearch;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ClusBeamHeuristicSS
extends ClusBeamHeuristic {
    public ClusBeamHeuristicSS(ClusStatistic stat, ClusAttributeWeights prod, Settings sett) {
        super(stat, sett);
        this.m_ClusteringWeights = prod;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double n_tot = c_tstat.getTotalWeight();
        double n_pos = c_pstat.getTotalWeight();
        double n_neg = n_tot - n_pos;
        if (n_pos < SettingsTree.MINIMAL_WEIGHT || n_neg < SettingsTree.MINIMAL_WEIGHT) {
            return Double.NEGATIVE_INFINITY;
        }
        if (missing.getTotalWeight() == 0.0) {
            this.m_Neg.copy(c_tstat);
            this.m_Neg.subtractFromThis(c_pstat);
            double pos_error = this.m_Pos.getSVarS(this.m_ClusteringWeights);
            double neg_error = this.m_Neg.getSVarS(this.m_ClusteringWeights);
            return this.m_TreeOffset - (pos_error + neg_error) / this.m_NbTrain - 2.0 * SettingsBeamSearch.SIZE_PENALTY;
        }
        double pos_freq = n_pos / n_tot;
        this.m_Pos.copy(c_pstat);
        this.m_Neg.copy(c_tstat);
        this.m_Neg.subtractFromThis(c_pstat);
        this.m_Pos.addScaled(pos_freq, missing);
        this.m_Neg.addScaled(1.0 - pos_freq, missing);
        double pos_error = this.m_Pos.getSVarS(this.m_ClusteringWeights);
        double neg_error = this.m_Neg.getSVarS(this.m_ClusteringWeights);
        return this.m_TreeOffset - (pos_error + neg_error) / this.m_NbTrain - 2.0 * SettingsBeamSearch.SIZE_PENALTY;
    }

    @Override
    public double estimateBeamMeasure(ClusNode tree) {
        if (tree.atBottomLevel()) {
            ClusStatistic total = tree.getClusteringStat();
            return -total.getSVarS(this.m_ClusteringWeights) / this.m_NbTrain - SettingsBeamSearch.SIZE_PENALTY;
        }
        double result = 0.0;
        for (int i = 0; i < tree.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            result += this.estimateBeamMeasure(child);
        }
        return result - SettingsBeamSearch.SIZE_PENALTY;
    }

    @Override
    public double computeLeafAdd(ClusNode leaf) {
        return -leaf.getClusteringStat().getSVarS(this.m_ClusteringWeights) / this.m_NbTrain;
    }

    @Override
    public String getName() {
        return "Beam Heuristic (Reduced Variance)" + this.getAttrHeuristicString() + " with " + this.m_ClusteringWeights.getName();
    }

    @Override
    public void setRootStatistic(ClusStatistic stat) {
        super.setRootStatistic(stat);
    }
}

