/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.sets;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.complex.SetAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusSetError;
import si.ijs.kt.clus.ext.structuredTypes.Set;
import si.ijs.kt.clus.ext.structuredTypes.SetOperations;
import si.ijs.kt.clus.ext.structuredTypes.SetStatistic;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class F1Score
extends ClusSetError {
    public static final long serialVersionUID = 1L;
    protected int[] m_nbEx;
    protected double[] m_SumErr;
    protected double[] m_SumSqErr;
    protected ClusAttributeWeights m_Weights;
    protected boolean m_PrintAllComps;
    protected ClusDistance innerDistance;

    public F1Score(ClusErrorList par, SetAttrType[] set, ClusDistance innerDistance) {
        this(par, set, null, true, innerDistance);
    }

    public F1Score(ClusErrorList par, SetAttrType[] set, ClusAttributeWeights weights, ClusDistance innerDistance) {
        this(par, set, weights, true, innerDistance);
    }

    public F1Score(ClusErrorList par, SetAttrType[] set, ClusAttributeWeights weights, boolean printall, ClusDistance innerDistance) {
        super(par, set);
        this.m_nbEx = new int[this.m_Dim];
        this.m_SumErr = new double[this.m_Dim];
        this.m_SumSqErr = new double[this.m_Dim];
        this.m_Weights = weights;
        this.m_PrintAllComps = printall;
        this.innerDistance = innerDistance;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.m_Dim; ++i) {
            this.m_SumErr[i] = 0.0;
            this.m_SumSqErr[i] = 0.0;
            this.m_nbEx[i] = 0;
        }
    }

    @Override
    public void setWeights(ClusAttributeWeights weights) {
        this.m_Weights = weights;
    }

    @Override
    public double getModelErrorComponent(int i) {
        double err;
        int nb = this.m_nbEx[i];
        double d = err = (double)nb != 0.0 ? this.m_SumErr[i] / (double)nb : 0.0;
        if (this.m_Weights != null) {
            err *= this.m_Weights.getWeight(this.getAttr(i));
        }
        return err;
    }

    @Override
    public double getModelError() {
        int i;
        double ss_tree = 0.0;
        int nb = 0;
        for (i = 0; i < this.m_Dim; ++i) {
            nb += this.m_nbEx[i];
        }
        if (this.m_Weights != null) {
            for (i = 0; i < this.m_Dim; ++i) {
                ss_tree += this.m_SumErr[i] * this.m_Weights.getWeight(this.getAttr(i));
            }
            return (double)nb != 0.0 ? ss_tree / (double)nb : 0.0;
        }
        for (i = 0; i < this.m_Dim; ++i) {
            ss_tree += this.m_SumErr[i];
        }
        return (double)nb != 0.0 ? ss_tree / (double)nb : 0.0;
    }

    @Override
    public double getModelErrorStandardError() {
        double sum_err = 0.0;
        double sum_sq_err = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            if (this.m_Weights != null) {
                sum_err += this.m_SumErr[i];
                sum_sq_err += this.m_SumSqErr[i];
                continue;
            }
            sum_err += this.m_SumErr[i] * this.m_Weights.getWeight(this.getAttr(i));
            sum_sq_err += this.m_SumSqErr[i] * F1Score.sqr(this.m_Weights.getWeight(this.getAttr(i)));
        }
        double n = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            n += (double)this.m_nbEx[i];
        }
        if (n <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double ss_x = (n * sum_sq_err - F1Score.sqr(sum_err)) / (n * (n - 1.0));
        return Math.sqrt(ss_x / n);
    }

    public static final double sqr(double value) {
        return value * value;
    }

    @Override
    public void addExample(double[] real, double[] predicted) {
        for (int i = 0; i < this.m_Dim; ++i) {
            double err = F1Score.sqr(real[i] - predicted[i]);
            ClusLogger.info(err);
            if (Double.isInfinite(err) || Double.isNaN(err)) continue;
            int n = i;
            this.m_SumErr[n] = this.m_SumErr[n] + err;
            int n2 = i;
            this.m_SumSqErr[n2] = this.m_SumSqErr[n2] + F1Score.sqr(err);
            int n3 = i;
            this.m_nbEx[n3] = this.m_nbEx[n3] + 1;
        }
    }

    private void addExample(Set realSet, Set predicted) throws ClusException {
        double error = ((double)(2 * SetOperations.getIntersectionCardinality(realSet, predicted, this.innerDistance)) + 0.0) / (double)(realSet.size() + predicted.size());
        if (realSet.size() == 0) {
            error = predicted.size() == 0 ? 1.0 : 0.0;
        } else if (predicted.size() == 0) {
            error = 0.0;
        }
        this.m_SumErr[0] = this.m_SumErr[0] + error;
        this.m_nbEx[0] = this.m_nbEx[0] + 1;
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) throws ClusException {
        Set predicted = ((SetStatistic)pred).getSetPred();
        Set realSet = this.getAttr(0).getSet(tuple);
        this.addExample(realSet, predicted);
    }

    @Override
    public void addExample(DataTuple real, DataTuple pred) throws ClusException {
        Set realSet = this.getAttr(0).getSet(real);
        Set predicted = this.getAttr(0).getSet(pred);
        this.addExample(realSet, predicted);
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public void add(ClusError other) {
        F1Score oe = (F1Score)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_SumErr[n] = this.m_SumErr[n] + oe.m_SumErr[i];
            int n2 = i;
            this.m_SumSqErr[n2] = this.m_SumSqErr[n2] + oe.m_SumSqErr[i];
            int n3 = i;
            this.m_nbEx[n3] = this.m_nbEx[n3] + oe.m_nbEx[i];
        }
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        if (this.m_PrintAllComps) {
            buf.append("[");
            for (int i = 0; i < this.m_Dim; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(fr.format(this.getModelErrorComponent(i)));
            }
            if (this.m_Dim > 1) {
                buf.append("]: ");
            } else {
                buf.append("]");
            }
        }
        if (this.m_Dim > 1 || !this.m_PrintAllComps) {
            buf.append(fr.format(this.getModelError()));
        }
        out.println(buf.toString());
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        ClusNumberFormat fr = this.getFormat();
        out.println(this.getPrefix() + "Mean over components F1S: " + fr.format(this.getModelError()));
    }

    @Override
    public String getName() {
        if (this.m_Weights == null) {
            return "F1 Score (F1S)";
        }
        return "Weighted F1 Score (F1S) (" + this.m_Weights.getName(this.m_Attrs) + ")";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new F1Score(par, this.m_Attrs, this.m_Weights, this.m_PrintAllComps, this.innerDistance);
    }

    @Override
    public double computeLeafError(ClusStatistic stat) {
        RegressionStat rstat = (RegressionStat)stat;
        return rstat.getSVarS(this.m_Weights) * (double)rstat.getNbAttributes();
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }
}

