/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class MicroPrecision
implements MlcHmlcSubError,
Serializable {
    protected int[] m_NbTruePositives;
    protected int[] m_NbFalsePositives;

    public MicroPrecision(int dim) {
        this.m_NbTruePositives = new int[dim];
        this.m_NbFalsePositives = new int[dim];
    }

    @Override
    public double getModelError(int dim) {
        int truePositives = 0;
        int falsePositives = 0;
        for (int i = 0; i < dim; ++i) {
            truePositives += this.m_NbTruePositives[i];
            falsePositives += this.m_NbFalsePositives[i];
        }
        if (ClusUtil.isZero(truePositives + falsePositives)) {
            return Double.NaN;
        }
        return (double)truePositives / (double)(truePositives + falsePositives);
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        int dim = actual.length;
        for (int i = 0; i < dim; ++i) {
            if (!predictedThresholded[i]) continue;
            if (actual[i]) {
                int n = i;
                this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                continue;
            }
            int n = i;
            this.m_NbFalsePositives[n] = this.m_NbFalsePositives[n] + 1;
        }
    }

    @Override
    public String getName() {
        return "MicroPrecision";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        MicroPrecision o = (MicroPrecision)other;
        for (int i = 0; i < this.m_NbTruePositives.length; ++i) {
            int n = i;
            this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + o.m_NbTruePositives[i];
            int n2 = i;
            this.m_NbFalsePositives[n2] = this.m_NbFalsePositives[n2] + o.m_NbFalsePositives[i];
        }
    }
}

