/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class MicroFOne
implements MlcHmlcSubError,
Serializable {
    protected int[] m_NbTruePositives;
    protected int[] m_NbFalsePositives;
    protected int[] m_NbFalseNegatives;

    public MicroFOne(int dim) {
        this.m_NbTruePositives = new int[dim];
        this.m_NbFalsePositives = new int[dim];
        this.m_NbFalseNegatives = new int[dim];
    }

    @Override
    public double getModelError(int dim) {
        int truePositives = 0;
        int falsePositives = 0;
        int falseNegatives = 0;
        for (int i = 0; i < dim; ++i) {
            truePositives += this.m_NbTruePositives[i];
            falsePositives += this.m_NbFalsePositives[i];
            falseNegatives += this.m_NbFalseNegatives[i];
        }
        double precision = (double)truePositives / (double)(truePositives + falsePositives);
        double recall = (double)truePositives / (double)(truePositives + falseNegatives);
        precision = ClusUtil.isNaNOrZero(precision) ? Double.NaN : precision;
        double d = recall = ClusUtil.isNaNOrZero(recall) ? Double.NaN : recall;
        if (ClusUtil.isNaNOrZero(precision + recall)) {
            return Double.NaN;
        }
        return 2.0 * precision * recall / (precision + recall);
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        int dim = actual.length;
        for (int i = 0; i < dim; ++i) {
            if (actual[i]) {
                if (predictedThresholded[i]) {
                    int n = i;
                    this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                    continue;
                }
                int n = i;
                this.m_NbFalseNegatives[n] = this.m_NbFalseNegatives[n] + 1;
                continue;
            }
            if (!predictedThresholded[i]) continue;
            int n = i;
            this.m_NbFalsePositives[n] = this.m_NbFalsePositives[n] + 1;
        }
    }

    @Override
    public String getName() {
        return "MicroFOne";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        MicroFOne o = (MicroFOne)other;
        for (int i = 0; i < this.m_NbTruePositives.length; ++i) {
            int n = i;
            this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + o.m_NbTruePositives[i];
            int n2 = i;
            this.m_NbFalsePositives[n2] = this.m_NbFalsePositives[n2] + o.m_NbFalsePositives[i];
            int n3 = i;
            this.m_NbFalseNegatives[n3] = this.m_NbFalseNegatives[n3] + o.m_NbFalseNegatives[i];
        }
    }
}

