/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class Coverage
implements MlcHmlcSubError,
Serializable {
    protected int m_RankSum = 0;
    protected int m_NbKnown = 0;
    protected int m_NbRelevantLabels = 0;

    @Override
    public double getModelError(int dim) {
        if (ClusUtil.isZero(this.m_NbKnown)) {
            return Double.NaN;
        }
        return (double)this.m_RankSum / (double)this.m_NbKnown;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        double[] scores = predicted;
        int dim = predicted.length;
        double minScore = Double.POSITIVE_INFINITY;
        int minScoreLabel = -1;
        int relevantLabels = 0;
        for (int i = 0; i < dim; ++i) {
            if (!actual[i]) continue;
            ++relevantLabels;
            if (!(minScore > scores[i])) continue;
            minScore = scores[i];
            minScoreLabel = i;
        }
        if (minScoreLabel >= 0) {
            int rank = 0;
            for (int i = 0; i < dim; ++i) {
                if (!(scores[i] >= scores[minScoreLabel])) continue;
                ++rank;
            }
            this.m_RankSum += rank;
            ++this.m_NbKnown;
            this.m_NbRelevantLabels += relevantLabels;
        }
    }

    @Override
    public String getName() {
        return "Coverage";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        this.m_RankSum += ((Coverage)other).m_RankSum;
        this.m_NbKnown += ((Coverage)other).m_NbKnown;
        this.m_NbRelevantLabels += ((Coverage)other).m_NbRelevantLabels;
    }
}

