/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class SubsetAccuracy
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected int m_NbCorrect = 0;
    protected int m_NbKnown = 0;

    public SubsetAccuracy(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    @Override
    public void reset() {
        this.m_NbCorrect = 0;
        this.m_NbKnown = 0;
    }

    @Override
    public void add(ClusError other) {
        SubsetAccuracy sa = (SubsetAccuracy)other;
        this.m_NbCorrect += sa.m_NbCorrect;
        this.m_NbKnown += sa.m_NbKnown;
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public double getModelError() {
        return (double)this.m_NbCorrect / (double)this.m_NbKnown;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()));
    }

    @Override
    public String getName() {
        return "SubsetAccuracy";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new SubsetAccuracy(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        int[] predicted = pred.getNominalPred();
        boolean atLeastOneKnown = false;
        boolean correctPrediction = true;
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            atLeastOneKnown = true;
            if (attr.getNominal(tuple) == predicted[i]) continue;
            correctPrediction = false;
            break;
        }
        if (atLeastOneKnown) {
            if (correctPrediction) {
                ++this.m_NbCorrect;
            }
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        boolean atLeastOneKnown = false;
        boolean correctPrediction = true;
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            atLeastOneKnown = true;
            if (attr.getNominal(tuple) == attr.getNominal(pred)) continue;
            correctPrediction = false;
            break;
        }
        if (atLeastOneKnown) {
            if (correctPrediction) {
                ++this.m_NbCorrect;
            }
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

