/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class MicroFOne
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected int[] m_NbTruePositives;
    protected int[] m_NbFalsePositives;
    protected int[] m_NbFalseNegatives;

    public MicroFOne(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
        this.m_NbTruePositives = new int[this.m_Dim];
        this.m_NbFalsePositives = new int[this.m_Dim];
        this.m_NbFalseNegatives = new int[this.m_Dim];
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    @Override
    public void reset() {
        Arrays.fill(this.m_NbTruePositives, 0);
        Arrays.fill(this.m_NbFalsePositives, 0);
        Arrays.fill(this.m_NbFalseNegatives, 0);
    }

    @Override
    public void add(ClusError other) {
        MicroFOne mF1 = (MicroFOne)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + mF1.m_NbTruePositives[i];
            int n2 = i;
            this.m_NbFalsePositives[n2] = this.m_NbFalsePositives[n2] + mF1.m_NbFalsePositives[i];
            int n3 = i;
            this.m_NbFalseNegatives[n3] = this.m_NbFalseNegatives[n3] + mF1.m_NbFalseNegatives[i];
        }
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    public double getMicroFOne(int i) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public double getModelError() {
        int truePositives = 0;
        int falsePositives = 0;
        int falseNegatives = 0;
        for (int i = 0; i < this.m_Dim; ++i) {
            truePositives += this.m_NbTruePositives[i];
            falsePositives += this.m_NbFalsePositives[i];
            falseNegatives += this.m_NbFalseNegatives[i];
        }
        double precision = (double)truePositives / (double)(truePositives + falsePositives);
        double recall = (double)truePositives / (double)(truePositives + falseNegatives);
        return 2.0 * precision * recall / (precision + recall);
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()));
    }

    @Override
    public String getName() {
        return "MicroFOne";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new MicroFOne(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        int[] predicted = pred.getNominalPred();
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            if (attr.getNominal(tuple) == 0) {
                if (predicted[i] == 0) {
                    int n = i;
                    this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                    continue;
                }
                int n = i;
                this.m_NbFalseNegatives[n] = this.m_NbFalseNegatives[n] + 1;
                continue;
            }
            if (predicted[i] != 0) continue;
            int n = i;
            this.m_NbFalsePositives[n] = this.m_NbFalsePositives[n] + 1;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            if (attr.getNominal(tuple) == 0) {
                if (attr.getNominal(pred) == 0) {
                    int n = i;
                    this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                    continue;
                }
                int n = i;
                this.m_NbFalseNegatives[n] = this.m_NbFalseNegatives[n] + 1;
                continue;
            }
            if (attr.getNominal(pred) != 0) continue;
            int n = i;
            this.m_NbFalsePositives[n] = this.m_NbFalsePositives[n] + 1;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

