/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class Coverage
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected int m_RankSum = 0;
    protected int m_NbKnown = 0;
    protected int m_NbRelevantLabels = 0;

    public Coverage(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }

    @Override
    public void reset() {
        this.m_RankSum = 0;
        this.m_NbKnown = 0;
        this.m_NbRelevantLabels = 0;
    }

    @Override
    public void add(ClusError other) {
        Coverage cv = (Coverage)other;
        this.m_RankSum += cv.m_RankSum;
        this.m_NbKnown += cv.m_NbKnown;
        this.m_NbRelevantLabels += cv.m_NbRelevantLabels;
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public double getModelError() {
        return (double)this.m_RankSum / (double)this.m_NbKnown;
    }

    public double getLabelCardinality() {
        return (double)this.m_NbRelevantLabels / (double)this.m_NbKnown;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()) + "(label cardinality: " + ClusFormat.FOUR_AFTER_DOT.format(this.getLabelCardinality()) + ")");
    }

    @Override
    public String getName() {
        return "Coverage";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new Coverage(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        NominalAttrType attr;
        double[] scores = ((ClassificationStat)pred).calcScores();
        double minScore = Double.POSITIVE_INFINITY;
        int minScoreLabel = -1;
        int relevantLabels = 0;
        for (int i = 0; i < this.m_Dim; ++i) {
            attr = this.getAttr(i);
            if (attr.isMissing(tuple) || attr.getNominal(tuple) != 0) continue;
            ++relevantLabels;
            if (!(minScore > scores[i])) continue;
            minScore = scores[i];
            minScoreLabel = i;
        }
        if (minScoreLabel >= 0) {
            int rank = 0;
            for (int i = 0; i < this.m_Dim; ++i) {
                attr = this.getAttr(i);
                if (attr.isMissing(tuple) || !(scores[i] >= scores[minScoreLabel])) continue;
                ++rank;
            }
            this.m_RankSum += rank;
            ++this.m_NbKnown;
            this.m_NbRelevantLabels += relevantLabels;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        try {
            throw new Exception("Coverage.addExample(DataTuple tuple, DataTuple pred) cannot be implemented.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

