/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class AveragePrecision
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected double m_NonnormalisedPrec = 0.0;
    protected int m_NbKnown = 0;

    public AveragePrecision(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    @Override
    public void reset() {
        this.m_NonnormalisedPrec = 0.0;
        this.m_NbKnown = 0;
    }

    @Override
    public void add(ClusError other) {
        AveragePrecision ap = (AveragePrecision)other;
        this.m_NonnormalisedPrec += ap.m_NonnormalisedPrec;
        this.m_NbKnown += ap.m_NbKnown;
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public double getModelError() {
        return this.m_NonnormalisedPrec / (double)this.m_NbKnown;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()));
    }

    @Override
    public String getName() {
        return "AveragePrecision";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new AveragePrecision(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        final double[] scores = ((ClassificationStat)pred).calcScores();
        ArrayList<Integer> indicesOfKnownValues = new ArrayList<Integer>();
        boolean[] isRelevant = new boolean[this.m_Dim];
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            indicesOfKnownValues.add(i);
            if (attr.getNominal(tuple) != 0) continue;
            isRelevant[i] = true;
        }
        Collections.sort(indicesOfKnownValues, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -Double.compare(scores[o1], scores[o2]);
            }
        });
        int nbOfRelevant = 0;
        double u = 0.0;
        if (indicesOfKnownValues.size() > 0) {
            for (int i = 0; i < indicesOfKnownValues.size(); ++i) {
                if (!isRelevant[(Integer)indicesOfKnownValues.get(i)]) continue;
                u += (double)(++nbOfRelevant) / (double)(i + 1);
            }
            this.m_NonnormalisedPrec += u / (double)nbOfRelevant;
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        try {
            throw new Exception("AveragePrecision.addExample(DataTuple tuple, DataTuple pred) cannot be implemented.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

