/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.common.multiscore;

import java.util.ArrayList;
import si.ijs.kt.clus.data.cols.ColTarget;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.error.common.multiscore.MultiScore;
import si.ijs.kt.clus.ext.ensemble.ClusOOBWeights;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSForestInfo;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class MultiScoreStat
extends ClusStatistic {
    public static final long serialVersionUID = 1L;
    protected int m_NbTarget;
    protected int[] m_Score;
    protected double[] m_MeanValues;

    public MultiScoreStat(Settings sett, ClusStatistic stat, MultiScore score) {
        super(sett);
        this.m_MeanValues = stat.getNumericPred();
        this.m_NbTarget = this.m_MeanValues.length;
        this.m_Score = score.multiScore(this.m_MeanValues);
    }

    @Override
    public String getArrayOfStatistic() {
        return null;
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        int i;
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (i = 0; i < this.m_NbTarget; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(1 - this.m_Score[i]);
        }
        buf.append("] : [");
        for (i = 0; i < this.m_NbTarget; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(fr.format(this.m_MeanValues[i]));
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public String getPredictedClassName(int idx) {
        return "";
    }

    @Override
    public double[] getNumericPred() {
        return this.m_MeanValues;
    }

    @Override
    public int[] getNominalPred() {
        return this.m_Score;
    }

    @Override
    public boolean samePrediction(ClusStatistic other) {
        MultiScoreStat or = (MultiScoreStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            if (this.m_Score[i] == or.m_Score[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public ClusStatistic cloneStat() {
        return null;
    }

    @Override
    public void update(ColTarget target, int idx) {
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
    }

    @Override
    public void calcMean() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void copy(ClusStatistic other) {
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
    }

    @Override
    public void add(ClusStatistic other) {
    }

    @Override
    public void addScaled(double scale, ClusStatistic other) {
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes) {
        throw new RuntimeException("si.ijs.kt.clus.error.common.multiscore.MultiScoreStat.vote(ArrayList) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusROSForestInfo ROSForestInfo) {
        throw new RuntimeException("si.ijs.kt.clus.error.common.multiscore.MultiScoreStat.vote(ArrayList<ClusStatistic>, ClusROSForestInfo) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusOOBWeights weights) {
        throw new RuntimeException("si.ijs.kt.clus.error.common.multiscore.MultiScoreStat.vote(ArrayList<ClusStatistic>, ArrayList<Double>) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusOOBWeights weights, ClusROSForestInfo ROSForestInfo) {
        throw new RuntimeException("si.ijs.kt.clus.error.common.multiscore.MultiScoreStat.vote(ArrayList<ClusStatistic>, ArrayList<Double>, ClusROSForestInfo) not implemented");
    }

    public void updateWeighted(SparseDataTuple tuple, int idx) {
    }

    @Override
    public int getNbStatisticComponents() {
        throw new RuntimeException(this.getClass().getName() + "getNbStatisticComponents(): not implemented");
    }

    @Override
    public void setParentStat(ClusStatistic parent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ClusStatistic getParentStat() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

