/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.common.multiscore;

import java.util.StringTokenizer;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.exception.ClusException;

public class MultiScore {
    protected double[] m_Thresholds;
    protected int m_NbValues;

    public MultiScore(ClusSchema schema, Settings sett) throws ClusException {
        String val = "";
        int len = val.length();
        int nb_wanted = 0;
        try {
            if (len > 2 && val.charAt(0) == '{' && val.charAt(len - 1) == '}') {
                StringTokenizer tokens = new StringTokenizer(val.substring(1, len - 1), ", ");
                this.m_NbValues = tokens.countTokens();
                if (this.m_NbValues != nb_wanted) {
                    throw new ClusException("Not enough (" + this.m_NbValues + " < " + nb_wanted + ") thresholds given for multi-score");
                }
                this.m_Thresholds = new double[this.m_NbValues];
                for (int i = 0; i < this.m_NbValues; ++i) {
                    this.m_Thresholds[i] = Double.parseDouble(tokens.nextToken());
                }
            } else {
                double thr = Double.parseDouble(val);
                this.m_NbValues = nb_wanted;
                this.m_Thresholds = new double[this.m_NbValues];
                for (int i = 0; i < this.m_NbValues; ++i) {
                    this.m_Thresholds[i] = thr;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new ClusException("Parse error reading multi-score values");
        }
    }

    public int getNbTarget() {
        return this.m_NbValues;
    }

    public int[] multiScore(double[] input) {
        int[] res = new int[input.length];
        for (int i = 0; i < this.m_NbValues; ++i) {
            res[i] = input[i] > this.m_Thresholds[i] ? 0 : 1;
        }
        return res;
    }

    public void multiScore(double[] input, int[] res) {
        for (int i = 0; i < this.m_NbValues; ++i) {
            res[i] = input[i] > this.m_Thresholds[i] ? 0 : 1;
        }
    }
}

