/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.common;

import java.io.IOException;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.main.ClusOutput;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.util.IntervalCollection;

public class ClusErrorOutput
extends ClusOutput {
    public ClusErrorOutput(String fname, ClusSchema schema, Settings sett) throws IOException {
        super(fname, schema, sett);
    }

    public ClusErrorOutput(String fname, Settings sett) throws IOException {
        super(fname, null, sett);
    }

    public ClusErrorOutput(ClusSchema schema, Settings sett) throws IOException {
        super(schema, sett);
    }

    @Override
    public void writeHeader() throws IOException {
        this.m_Writer.println("@relation experiment");
        this.m_Writer.println("@attribute Dataset {" + this.m_Sett.getData().getDataFile() + "}");
        this.m_Writer.println("@attribute Run numeric");
        this.m_Writer.println("@attribute Fold {01,02,03,04,05,06,07,08,09,10}");
        this.m_Writer.println("@attribute Algo string");
        this.m_Writer.println("@attribute Targets string");
        this.m_Writer.println("@attribute Descriptive string");
        this.m_Writer.println("@attribute MainTarget numeric");
        this.m_Writer.println("@attribute RMSE_Default numeric");
        this.m_Writer.println("@attribute RMSE_Original numeric");
        this.m_Writer.println("@attribute RMSE_Pruned numeric");
        this.m_Writer.println("@attribute WRMSE_Default numeric");
        this.m_Writer.println("@attribute WRMSE_Original numeric");
        this.m_Writer.println("@attribute WRMSE_Pruned numeric");
        this.m_Writer.println("@attribute OriginalModelSize numeric");
        this.m_Writer.println("@attribute PrunedModelSize numeric");
        this.m_Writer.println("@attribute nrSupportTargets numeric");
        this.m_Writer.println("@attribute inductionTime numeric");
        this.m_Writer.println("@data");
        this.m_Writer.flush();
    }

    public void writeOutput(ClusRun cr, boolean detail, boolean outputtrain, double[] clusteringWeights) throws IOException, ClusException {
        this.m_Writer.print(this.m_Sett.getData().getDataFile() + ",");
        this.m_Writer.print(this.m_Sett.getGeneral().getRandomSeed() + ",");
        this.m_Writer.print(cr.getIndexString() + ",");
        IntervalCollection targets = new IntervalCollection(this.m_Sett.getAttribute().getTarget());
        this.m_Writer.print(this.m_Sett.getTree().getPruningMethodName() + ",");
        this.m_Writer.print(this.m_Sett.getAttribute().getTarget() + ",");
        this.m_Writer.print(this.m_Sett.getAttribute().getDescriptive() + ",");
        this.m_Writer.print(this.m_Sett.getSIT().getMainTarget());
        if (this.m_Sett.getSIT().getMainTarget().equals("Default")) {
            return;
        }
        int mt = new Integer(this.m_Sett.getSIT().getMainTarget());
        int mt_idx = mt - targets.getMinIndex();
        ClusErrorList tr_err = cr.getTestError();
        if (tr_err != null) {
            for (int i = 1; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ClusModelInfo inf = cr.getModelInfo(j);
                    ClusErrorList parent = inf.getError(1);
                    ClusError err2 = parent.getError(i);
                    this.m_Writer.print("," + err2.getModelErrorComponent(mt_idx));
                }
            }
            for (int j = 1; j < 3; ++j) {
                ClusModelInfo inf = cr.getModelInfo(j);
                this.m_Writer.print("," + inf.getModelSize());
            }
        }
        int supportTargetCounter = -1;
        for (int j = 0; j < clusteringWeights.length; ++j) {
            if (clusteringWeights[j] != 1.0) continue;
            ++supportTargetCounter;
        }
        this.m_Writer.print("," + supportTargetCounter);
        this.m_Writer.print("," + ClusFormat.FOUR_AFTER_DOT.format((double)cr.getInductionTime() / 1000.0));
        this.m_Writer.println();
        this.m_Writer.flush();
    }
}

