/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.TupleIterator;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.main.ClusModelInfoList;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClusErrorList
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected int m_NbTotal = -1;
    protected int m_NbExamples;
    protected int m_NbCover;
    protected ArrayList<ClusError> m_Error = new ArrayList();
    protected ArrayList<ClusError> m_ErrorWithNulls = new ArrayList();
    private HashMap<String, Integer> m_ErrorNameMap = new HashMap();

    public void setNbTotal(int nb) {
        this.m_NbTotal = nb;
    }

    public int getNbTotal() {
        return this.m_NbTotal == -1 ? this.m_NbExamples : this.m_NbTotal;
    }

    public void setNbExamples(int nb) {
        this.m_NbExamples = nb;
    }

    public void setNbExamples(int nb, int cover) {
        this.m_NbExamples = nb;
        this.m_NbCover = cover;
    }

    public void setWeights(ClusAttributeWeights weights) {
        for (int i = 0; i < this.m_Error.size(); ++i) {
            ClusError err = this.m_Error.get(i);
            err.setWeights(weights);
        }
    }

    public void checkChildren() {
        int nb_e = this.m_Error.size();
        for (int i = 0; i < nb_e; ++i) {
            ClusError err = this.m_Error.get(i);
            if (err.getParent() == this) continue;
            ClusLogger.info("Child: " + err + " has incorrect parent: " + err.getParent() + " " + this);
        }
    }

    public void calcError(TupleIterator iter, ClusModel model) throws ClusException, IOException, InterruptedException {
        iter.init();
        DataTuple tuple = iter.readTuple();
        while (tuple != null) {
            ClusStatistic pred = model.predictWeighted(tuple);
            this.addExample(tuple, pred);
            tuple = iter.readTuple();
        }
        iter.close();
    }

    public ClusErrorList getErrorClone() throws ClusException {
        ClusErrorList res = new ClusErrorList();
        int nb = this.m_Error.size();
        for (int i = 0; i < nb; ++i) {
            ClusError err = this.m_Error.get(i);
            res.addError(err.getErrorClone(res));
        }
        return res;
    }

    public ClusErrorList getErrorClone(String model) throws ClusException {
        ClusErrorList res = new ClusErrorList();
        int nb = this.m_Error.size();
        for (int i = 0; i < nb; ++i) {
            ClusError err = this.m_Error.get(i);
            if (err.isComputeForModel(model)) {
                res.addError(err.getErrorClone(res));
                continue;
            }
            res.addError(null);
        }
        return res;
    }

    public void addError(ClusError err) {
        if (err != null) {
            String name = err.getName();
            this.m_Error.add(err);
            if (!this.m_ErrorNameMap.containsKey(name)) {
                this.m_ErrorNameMap.put(name, this.m_Error.size() - 1);
            } else {
                System.err.println("Error names must be unique!");
                System.err.println(name + " already exists in the list. Exiting...");
                System.exit(1);
            }
        }
        this.m_ErrorWithNulls.add(err);
    }

    public void addErrors(ClusErrorList error) {
        for (int i = 0; i < error.getNbErrors(); ++i) {
            this.addError(error.getError(i));
        }
    }

    public int getNbErrors() {
        return this.m_Error.size();
    }

    public ClusError getFirstError() {
        return this.getError(0);
    }

    public ClusError getError(int idx) {
        if (idx + 1 > this.m_Error.size()) {
            System.err.println("Unable to get error at index " + idx);
        }
        return this.m_Error.get(idx);
    }

    public ClusError getErrorOrNull(int idx) {
        return this.m_ErrorWithNulls.get(idx);
    }

    public void clear() {
        for (int i = 0; i < this.m_ErrorWithNulls.size(); ++i) {
            this.m_ErrorWithNulls.set(i, null);
        }
    }

    public ClusError getErrorByName(String name) {
        if (this.m_ErrorNameMap.containsKey(name)) {
            return this.getError(this.m_ErrorNameMap.get(name));
        }
        return null;
    }

    public void compute(RowData data, ClusModelInfo model) throws ClusException {
        int nb = this.m_Error.size();
        for (int i = nb - 1; i >= 0; --i) {
            ClusError err = this.m_Error.get(i);
            if (err.isComputeForModel(model.getName())) {
                err.compute(data, model.getModel());
                continue;
            }
            this.m_Error.remove(i);
        }
        this.m_NbCover = this.m_NbExamples = data.getNbRows();
    }

    public void compute(RowData data, ClusModel model) throws ClusException {
        int nb = this.m_Error.size();
        for (int i = 0; i < nb; ++i) {
            ClusError err = this.m_Error.get(i);
            err.compute(data, model);
        }
        this.m_NbCover = this.m_NbExamples = data.getNbRows();
    }

    public void reset() {
        int nb = this.m_Error.size();
        for (int i = 0; i < nb; ++i) {
            ClusError err = this.m_Error.get(i);
            err.reset();
        }
        this.m_NbExamples = 0;
        this.m_NbCover = 0;
    }

    public void addExample(DataTuple tuple, ClusStatistic stat) throws ClusException {
        ++this.m_NbExamples;
        int nb = this.m_Error.size();
        if (stat != null && stat.isValidPrediction()) {
            ++this.m_NbCover;
            for (int i = 0; i < nb; ++i) {
                ClusError err = this.m_Error.get(i);
                err.addExample(tuple, stat);
            }
        } else {
            for (int i = 0; i < nb; ++i) {
                ClusError err = this.m_Error.get(i);
                err.addInvalid(tuple);
            }
        }
    }

    public void addExample(DataTuple real, DataTuple pred) throws ClusException {
        ++this.m_NbExamples;
        int nb = this.m_Error.size();
        for (int i = 0; i < nb; ++i) {
            ClusError err = this.m_Error.get(i);
            err.addExample(real, pred);
        }
    }

    public void addExample() {
        ++this.m_NbExamples;
        ++this.m_NbCover;
    }

    public void add(ClusErrorList par) {
        int nb = this.m_ErrorWithNulls.size();
        for (int i = 0; i < nb; ++i) {
            ClusError your;
            ClusError my = this.m_ErrorWithNulls.get(i);
            if (my == null || (your = par.getErrorByName(my.getName())) == null) continue;
            my.add(your);
        }
        this.m_NbExamples += par.getNbExamples();
        this.m_NbCover += par.getNbCover();
    }

    public void updateFromGlobalMeasure(ClusErrorList par) {
        int nb = this.m_Error.size();
        for (int i = 0; i < nb; ++i) {
            ClusError err = this.m_Error.get(i);
            err.updateFromGlobalMeasure(par.getError(i));
        }
        this.setNbTotal(par.getNbExamples());
    }

    public double getErrorClassif() {
        ClusError err = this.getError(0);
        return err.get_error_classif();
    }

    public double getErrorAccuracy() {
        ClusError err = this.getError(0);
        return err.get_accuracy();
    }

    public double getErrorPrecision() {
        ClusError err = this.getError(0);
        return err.get_precision();
    }

    public double getErrorRecall() {
        ClusError err = this.getError(0);
        return err.get_recall();
    }

    public double getErrorAuc() {
        ClusError err = this.getError(0);
        return err.get_auc();
    }

    public void showError(PrintWriter out) {
        int nb = this.m_Error.size();
        out.println("Number of examples: " + this.getNbTotal() + " (covered: " + this.getNbCover() + ")");
        for (int i = 0; i < nb; ++i) {
            ClusError err1 = this.getError(i);
            out.print(err1.getName() + ": ");
            err1.showModelError(out, 1);
        }
    }

    public static boolean checkCoverage(ClusModelInfoList models, int type, int nb) {
        int nb_models = models.getNbModels();
        for (int j = 0; j < nb_models; ++j) {
            ClusErrorList parent;
            if (models.getModelInfo(j) == null || (parent = models.getModelInfo(j).getError(type)).getNbCover() == nb) continue;
            return false;
        }
        return true;
    }

    public void showError(ClusModelInfoList models, int type, String bName, PrintWriter out, Settings sett) throws IOException {
        int nb = this.m_Error.size();
        ClusModelInfo definf = models.getModelInfo(0);
        if (definf == null) {
            System.err.println("DEFAULT model is null!");
            return;
        }
        ClusErrorList defpar = definf.getError(type);
        out.println("Number of examples: " + defpar.getNbExamples());
        if (sett.getHMTR().isSectionHMTREnabled()) {
            out.println("HMTR weight: " + sett.getHMTR().getHMTRHierarchyWeight().getStringValue());
        }
        int nb_models = models.getNbModels();
        if (!ClusErrorList.checkCoverage(models, type, defpar.getNbExamples())) {
            out.println("Coverage:");
            for (int j = 0; j < nb_models; ++j) {
                ClusModelInfo inf = models.getModelInfo(j);
                if (inf == null) continue;
                ClusErrorList parent = inf.getError(type);
                out.println("  " + inf.getName() + ": " + parent.getNbCover());
            }
        }
        for (int i = 0; i < nb; ++i) {
            ClusModelInfo inf;
            int j;
            if (sett.getHMTR().isSectionHMTREnabled() && i == nb / 2) {
                out.println();
                out.println("\t***** HMTR leaves only w = " + sett.getHMTR().getHMTRHierarchyWeight().getStringValue() + " *****");
                out.println();
            }
            ClusError err1 = this.getError(i);
            boolean has_models = false;
            for (j = 0; j < nb_models; ++j) {
                inf = models.getModelInfo(j);
                if (inf == null || inf.getError(type).getErrorByName(err1.getName()) == null) continue;
                has_models = true;
                break;
            }
            if (!has_models) continue;
            out.println(err1.getName());
            for (j = 0; j < nb_models; ++j) {
                ClusError err2;
                inf = models.getModelInfo(j);
                if (inf == null || (err2 = inf.getError(type).getErrorByName(err1.getName())) == null) continue;
                if (err2.isMultiLine()) {
                    out.print("   " + inf.getName() + ": ");
                } else {
                    out.print("   " + StringUtils.printStr(inf.getName(), 15) + ": ");
                }
                err2.showModelError(out, bName, 1);
            }
        }
    }

    public static void printExtraError(ClusModelInfoList models, int type, PrintWriter out) {
        int ctr = 0;
        int nb_models = models.getNbModels();
        for (int j = 0; j < nb_models; ++j) {
            ClusErrorList parent;
            ClusModelInfo inf = models.getModelInfo(j);
            if (inf == null || (parent = inf.getExtraError(type)) == null || !inf.hasModel()) continue;
            int nb_err = parent.getNbErrors();
            for (int i = 0; i < nb_err; ++i) {
                ClusError err = parent.getError(i);
                out.print(err.getName() + ": " + StringUtils.printStr(inf.getName(), 15) + ": ");
                err.showModelError(out, 1);
                ++ctr;
            }
        }
        if (ctr != 0) {
            out.println();
        }
    }

    public void showErrorBrief(ClusModelInfoList models, int type, PrintWriter out) {
        for (int i = 0; i < this.m_Error.size(); ++i) {
            ClusError err1 = this.getError(i);
            if (type == 0) {
                out.print("Train ");
            } else {
                out.print("Test ");
            }
            out.println(err1.getName());
            int nb_models = models.getNbModels();
            for (int j = 0; j < nb_models; ++j) {
                ClusModelInfo inf = models.getModelInfo(j);
                ClusErrorList parent = inf.getError(type);
                ClusError err2 = parent.getErrorByName(err1.getName());
                if (err2 == null) continue;
                out.print("   " + StringUtils.printStr(inf.getName(), 15) + ": ");
                err2.showModelError(out, 3);
            }
        }
    }

    public String getPrefix() {
        return "   ";
    }

    public int getNbExamples() {
        return this.m_NbExamples;
    }

    public int getNbCover() {
        return this.m_NbCover;
    }

    public ClusNumberFormat getFormat() {
        return ClusFormat.FOUR_AFTER_DOT;
    }
}

