/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public abstract class ClusError
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final int DETAIL_NEVER_VISIBLE = 0;
    public static final int DETAIL_SMALL = 1;
    public static final int DETAIL_ALWAYS_VISIBLE = 2;
    public static final int DETAIL_VERY_SMALL = 3;
    protected static final String DEFAULT_ERROR = "Default error: ";
    protected static final String TREE_ERROR = "Tree error: ";
    protected static final String RELATIVE_ERROR = "Relative error: ";
    protected static final String DEFAULT_POSTFIX = " ";
    protected static final String TREE_POSTFIX = "    ";
    protected static final String RELATIVE_POSTFIX = "";
    protected int m_Dim;
    protected ClusErrorList m_Parent;
    private String additionalInfo = "";
    private static final String ADDITIONAL_INFO_FORMAT = " [%s]";

    public ClusError(ClusErrorList par, int dim) {
        this.m_Dim = dim;
        this.m_Parent = par;
    }

    public ClusError(ClusErrorList par) {
        this(par, 0);
    }

    protected void setAdditionalInfo(String info) {
        if (!info.trim().equals(RELATIVE_POSTFIX)) {
            this.additionalInfo = info;
        }
    }

    protected String getAdditionalInfoFormatted() {
        if (!this.additionalInfo.trim().equals(RELATIVE_POSTFIX)) {
            return String.format(ADDITIONAL_INFO_FORMAT, this.additionalInfo);
        }
        return RELATIVE_POSTFIX;
    }

    protected String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public abstract boolean shouldBeLow();

    public boolean isMultiLine() {
        return false;
    }

    public boolean isComputeForModel(String name) {
        return true;
    }

    public void setWeights(ClusAttributeWeights weights) {
    }

    public abstract String getName();

    public void reset() {
        System.err.println(this.getClass().getName() + ": reset() not implemented!");
    }

    public void normalize(double[] fac) {
        System.err.println(this.getClass().getName() + ": normalize() not implemented!");
    }

    public void add(ClusError other) {
        System.err.println(this.getClass().getName() + ": add() not implemented!");
    }

    public void addExample(DataTuple tuple, ClusStatistic pred) throws ClusException {
        System.err.println(this.getClass().getName() + ": addExample() not implemented!");
    }

    public void addExample(DataTuple real, DataTuple pred) throws ClusException {
        System.err.println(this.getClass().getName() + ": addExample() not implemented!");
    }

    public void addInvalid(DataTuple tuple) {
        System.err.println(this.getClass().getName() + ": addInvalid() not implemented!");
    }

    public void compute(RowData data, ClusModel model) throws ClusException {
        System.err.println(this.getClass().getName() + ": compute() not implemented!");
    }

    public void updateFromGlobalMeasure(ClusError global) {
    }

    public double getModelError() {
        return this.getModelErrorAdditive() / (double)this.getNbExamples();
    }

    public double getModelErrorAdditive() {
        ClusLogger.info(this.getClass().getName() + "::getModelErrorAdditive() not implemented!");
        return 0.0;
    }

    public double getModelErrorStandardError() {
        return Double.POSITIVE_INFINITY;
    }

    public double getModelErrorComponent(int i) {
        throw new RuntimeException("This method should be either implemented by a subclass or not at all.");
    }

    public abstract ClusError getErrorClone(ClusErrorList var1) throws ClusException;

    public ClusError getErrorClone() throws ClusException {
        return this.getErrorClone(this.getParent());
    }

    public int getDetailLevel() {
        return 2;
    }

    public double get_error_classif() {
        return 0.0;
    }

    public double get_accuracy() {
        return 0.0;
    }

    public double get_precision() {
        return 0.0;
    }

    public double get_recall() {
        return 0.0;
    }

    public double get_auc() {
        return 0.0;
    }

    public void showModelError(PrintWriter out, String bName, int detail) throws IOException {
        this.showModelError(out, detail);
    }

    public void showModelError(PrintWriter out, int detail) {
        for (int i = 0; i < this.m_Dim; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(this.getModelErrorComponent(i));
        }
        out.println();
    }

    public void showRelativeModelError(PrintWriter out, int detail) {
        this.showModelError(out, detail);
    }

    public ClusErrorList getParent() {
        return this.m_Parent;
    }

    public String getPrefix() {
        return this.m_Parent.getPrefix();
    }

    public int getNbExamples() {
        return this.m_Parent.getNbExamples();
    }

    public int getNbTotal() {
        return this.m_Parent.getNbTotal();
    }

    public int getNbCover() {
        return this.m_Parent.getNbCover();
    }

    public double getCoverage() {
        int nb = this.getNbTotal();
        return nb == 0 ? 0.0 : (double)this.getNbCover() / (double)nb;
    }

    public ClusNumberFormat getFormat() {
        return this.m_Parent.getFormat();
    }

    public int getDimension() {
        return this.m_Dim;
    }

    public String showDoubleArray(double[] arr) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(fr.format(arr[i]));
        }
        buf.append("]");
        return buf.toString();
    }

    public String showDoubleArray(double[] arr1, double[] arr2) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < arr1.length; ++i) {
            double el;
            double d = el = arr2[i] != 0.0 ? arr1[i] / arr2[i] : 0.0;
            if (i != 0) {
                buf.append(",");
            }
            buf.append(fr.format(el));
        }
        buf.append("]");
        return buf.toString();
    }

    public String showDoubleArray(double[] arr1, double div) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < arr1.length; ++i) {
            double el;
            double d = el = div != 0.0 ? arr1[i] / div : 0.0;
            if (i != 0) {
                buf.append(",");
            }
            buf.append(fr.format(el));
        }
        buf.append("]");
        return buf.toString();
    }

    public double computeLeafError(ClusStatistic stat) {
        ClusLogger.info(this.getClass().getName() + "::computeLeafError() not yet implemented");
        return 0.0;
    }

    public double computeTreeErrorClusteringAbsolute(ClusNode tree) {
        if (tree.atBottomLevel()) {
            return this.computeLeafError(tree.getClusteringStat());
        }
        double result = 0.0;
        for (int i = 0; i < tree.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            result += this.computeTreeErrorClusteringAbsolute(child);
        }
        return result;
    }
}

