/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNumericError;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class SpearmanRankCorrelation
extends ClusNumericError
implements ComponentError {
    private ArrayList<ArrayList<Double>> m_Predictions = new ArrayList();
    private ArrayList<ArrayList<Double>> m_TrueValues = new ArrayList();
    private double[] m_Correlations;
    private boolean m_CorrelationsUpToDate;
    private static final double PLACEHOLDER = -2506.1991;

    public SpearmanRankCorrelation(ClusErrorList par, NumericAttrType[] num) {
        this(par, num, "");
    }

    public SpearmanRankCorrelation(ClusErrorList par, NumericAttrType[] num, String info) {
        super(par, num);
        for (int i = 0; i < this.m_Dim; ++i) {
            this.m_Predictions.add(new ArrayList());
            this.m_TrueValues.add(new ArrayList());
        }
        this.m_Correlations = new double[this.m_Dim];
        Arrays.fill(this.m_Correlations, -2506.1991);
        this.m_CorrelationsUpToDate = false;
        this.setAdditionalInfo(info);
    }

    @Override
    public void addExample(double[] real, double[] predicted) {
        for (int i = 0; i < this.m_Dim; ++i) {
            this.m_TrueValues.get(i).add(real[i]);
            this.m_Predictions.get(i).add(predicted[i]);
        }
        this.m_CorrelationsUpToDate = false;
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        double[] predicted = pred.getNumericPred();
        double[] real = new double[this.m_Dim];
        for (int i = 0; i < this.m_Dim; ++i) {
            real[i] = this.getAttr(i).getNumeric(tuple);
        }
        this.addExample(real, predicted);
    }

    @Override
    public void addExample(DataTuple real, DataTuple pred) {
        double[] real_values = new double[this.m_Dim];
        double[] predicted_values = new double[this.m_Dim];
        for (int i = 0; i < this.m_Dim; ++i) {
            real_values[i] = this.getAttr(i).getNumeric(real);
            predicted_values[i] = this.getAttr(i).getNumeric(pred);
        }
        this.addExample(real_values, predicted_values);
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public void add(ClusError other) {
        SpearmanRankCorrelation o_spearman = (SpearmanRankCorrelation)other;
        for (int j = 0; j < o_spearman.m_Predictions.size(); ++j) {
            double[] real = new double[this.m_Dim];
            double[] predicted = new double[this.m_Dim];
            for (int i = 0; i < this.m_Dim; ++i) {
                real[i] = o_spearman.m_TrueValues.get(j).get(i);
                predicted[i] = o_spearman.m_Predictions.get(j).get(i);
            }
            this.addExample(real, predicted);
        }
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        double avg_corr = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            double corr = this.getModelErrorComponent(i);
            buf.append(fr.format(corr));
            avg_corr += corr;
        }
        buf.append("]: " + fr.format(avg_corr /= (double)this.m_Dim));
        out.println(buf.toString());
    }

    @Override
    public double getModelErrorComponent(int i) {
        if (!this.m_CorrelationsUpToDate) {
            this.computeSpearmanRankCorrelations();
        }
        return this.m_Correlations[i];
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    @Override
    public String getName() {
        return "Spearman Rank Correlation";
    }

    public boolean hasSummary() {
        return false;
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new SpearmanRankCorrelation(par, this.m_Attrs, this.getAdditionalInfo());
    }

    private void computeSpearmanRankCorrelations() {
        int n = this.m_Predictions.get(0).size();
        for (int i = 0; i < this.m_Dim; ++i) {
            double[] temp_true = new double[n];
            double[] temp_pred = new double[n];
            for (int j = 0; j < n; ++j) {
                temp_true[j] = this.m_TrueValues.get(i).get(j);
                temp_pred[j] = this.m_Predictions.get(i).get(j);
            }
            double[] ranks_true = ClusUtil.getRanks(temp_true);
            double[] ranks_pred = ClusUtil.getRanks(temp_pred);
            this.m_Correlations[i] = ClusUtil.correlation(ranks_true, ranks_pred);
        }
        this.m_CorrelationsUpToDate = true;
    }
}

