/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.MSError;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class RRMSError
extends MSError {
    public static final long serialVersionUID = 1L;

    public RRMSError(ClusErrorList par, NumericAttrType[] num) {
        super(par, num);
    }

    public RRMSError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights) {
        super(par, num, weights);
    }

    public RRMSError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights, boolean printall) {
        super(par, num, weights, printall, "");
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void add(ClusError other) {
        super.add(other);
        RRMSError castedOther = (RRMSError)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_SumTrueValues[n] = this.m_SumTrueValues[n] + castedOther.m_SumTrueValues[i];
            int n2 = i;
            this.m_SumSquaredTrueValues[n2] = this.m_SumSquaredTrueValues[n2] + castedOther.m_SumSquaredTrueValues[i];
        }
    }

    @Override
    public void addExample(double[] real, double[] predicted) {
        super.addExample(real, predicted, true);
    }

    @Override
    public void addExample(double[] real, boolean[] predicted) {
        super.addExample(real, predicted, true);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        super.addExample(tuple, pred, true);
    }

    @Override
    public void addExample(DataTuple real, DataTuple pred) {
        super.addExample(real, pred, true);
    }

    @Override
    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        if (this.m_PrintAllComps) {
            buf.append("[");
            for (int i = 0; i < this.m_Dim; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(fr.format(this.getModelErrorComponent(i)));
            }
            if (this.m_Dim > 1) {
                buf.append("]: ");
            } else {
                buf.append("]");
            }
        }
        if (this.m_Dim > 1 || !this.m_PrintAllComps) {
            buf.append(fr.format(this.getModelError()));
        }
        out.println(buf.toString());
    }

    @Override
    public String getName() {
        return "Root Relative Squared Error (RRMSE)";
    }

    @Override
    public double getModelError() {
        double sum = 0.0;
        for (int i = 0; i < this.m_Attrs.length; ++i) {
            sum += this.getModelErrorComponent(i);
        }
        return sum / (double)this.m_Attrs.length;
    }

    @Override
    public double getModelErrorComponent(int i) {
        double modelError = super.getModelErrorComponent(i);
        double defaultModelError = (this.m_SumSquaredTrueValues[i] - this.m_SumTrueValues[i] * this.m_SumTrueValues[i] / (double)this.m_nbEx[i]) / (double)this.m_nbEx[i];
        if (defaultModelError == 0.0) {
            ClusLogger.info("Default error is zero.");
        }
        return Math.sqrt(modelError / defaultModelError);
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new RRMSError(par, this.m_Attrs, this.m_Weights, this.m_PrintAllComps);
    }
}

