/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.Serializable;
import java.util.ArrayList;
import si.ijs.kt.clus.error.BinaryPredictionList;
import si.ijs.kt.clus.util.jeans.math.MathUtil;
import si.ijs.kt.clus.util.jeans.util.compound.DoubleBooleanCount;

public class ROCAndPRCurve
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected double m_AreaROC;
    protected double m_AreaPR;
    protected double[] m_Thresholds;
    protected transient boolean m_ExtendPR;
    protected transient int m_PrevTP;
    protected transient int m_PrevFP;
    protected transient ArrayList<double[]> m_ROC;
    protected transient ArrayList<double[]> m_PR;
    protected transient BinaryPredictionList m_Values;
    protected transient double[] m_PrecisionAtRecall;

    public ROCAndPRCurve(BinaryPredictionList list) {
        this.m_Values = list;
    }

    public void clear() {
        this.m_ROC.clear();
        this.m_PR.clear();
    }

    public ArrayList<double[]> getROCCurve() {
        return this.m_ROC;
    }

    public ArrayList<double[]> getPRCurve() {
        return this.m_PR;
    }

    public double getAreaROC() {
        return this.m_AreaROC;
    }

    public double getAreaPR() {
        return this.m_AreaPR;
    }

    public void computeCurves() {
        this.m_ROC = new ArrayList();
        this.m_PR = new ArrayList();
        this.m_AreaPR = 0.0;
        this.m_AreaROC = 0.5;
        if (this.m_Values.getNbPos() != 0) {
            this.enumerateThresholds();
            this.m_AreaPR = this.computeArea(this.m_PR);
            if (this.m_Values.getNbNeg() != 0) {
                this.m_AreaROC = this.computeArea(this.m_ROC);
            }
        }
    }

    public void setThresholds(double[] thr) {
        this.m_Thresholds = thr;
    }

    public void enumerateThresholds() {
        if (this.m_Thresholds == null) {
            this.enumerateThresholdsAll();
        } else {
            this.enumerateThresholdsSelected(this.m_Thresholds);
        }
    }

    public void enumerateThresholdsAll() {
        this.m_ExtendPR = true;
        this.addOutputROC(0, 0);
        boolean first = true;
        int TP_cnt = 0;
        int FP_cnt = 0;
        double prev = Double.NaN;
        for (int i = 0; i < this.m_Values.size(); ++i) {
            DoubleBooleanCount val = this.m_Values.get(i);
            if (val.getDouble() != prev && !first) {
                this.addOutput(TP_cnt, FP_cnt);
            }
            if (val.getBoolean().booleanValue()) {
                TP_cnt += val.getCount();
            } else {
                FP_cnt += val.getCount();
            }
            prev = val.getDouble();
            first = false;
        }
        this.addOutput(TP_cnt, FP_cnt);
    }

    public void enumerateThresholdsSelected(double[] thr) {
        this.m_ExtendPR = true;
        this.addOutputROC(0, 0);
        int idx = 0;
        int TP_cnt = 0;
        int FP_cnt = 0;
        int prevTP_cnt = 0;
        int prevFP_cnt = 0;
        for (int i = thr.length - 1; i >= 0; --i) {
            DoubleBooleanCount val = null;
            while (idx < this.m_Values.size()) {
                DoubleBooleanCount doubleBooleanCount;
                val = this.m_Values.get(idx);
                if (!(doubleBooleanCount.getDouble() >= thr[i])) break;
                if (val.getBoolean().booleanValue()) {
                    TP_cnt += val.getCount();
                } else {
                    FP_cnt += val.getCount();
                }
                ++idx;
            }
            if (TP_cnt != prevTP_cnt || FP_cnt != prevFP_cnt) {
                this.addOutput(TP_cnt, FP_cnt);
            }
            prevTP_cnt = TP_cnt;
            prevFP_cnt = FP_cnt;
        }
        this.addOutput(TP_cnt, FP_cnt);
    }

    public double computeArea(ArrayList<double[]> curve) {
        double area = 0.0;
        if (curve.size() > 0) {
            double[] prev = curve.get(0);
            for (int i = 1; i < curve.size(); ++i) {
                double[] pt = curve.get(i);
                area += 0.5 * (pt[1] + prev[1]) * (pt[0] - prev[0]);
                prev = pt;
            }
        }
        return area;
    }

    public void addOutput(int TP, int FP) {
        this.addOutputROC(TP, FP);
        this.addOutputPR(TP, FP);
    }

    public void addOutputROC(int TP, int FP) {
        double[] point = new double[]{(double)FP / (double)this.m_Values.getNbNeg(), (double)TP / (double)this.m_Values.getNbPos()};
        this.m_ROC.add(point);
    }

    public void addOutputPR(int TP, int FP) {
        int P = TP + FP;
        if (P != 0) {
            double prec = (double)TP / (double)P;
            double recall = (double)TP / (double)this.m_Values.getNbPos();
            if (this.m_ExtendPR) {
                this.addPointPR(prec, 0.0);
                this.m_ExtendPR = false;
            } else {
                for (int crTP = this.m_PrevTP + 1; crTP < TP; ++crTP) {
                    double crFP = (double)this.m_PrevFP + ((double)FP - (double)this.m_PrevFP) / (double)(TP - this.m_PrevTP) * (double)(crTP - this.m_PrevTP);
                    double crPrec = (double)crTP / ((double)crTP + crFP);
                    double crRecall = (double)crTP / (double)this.m_Values.getNbPos();
                    this.addPointPROptimized(crPrec, crRecall);
                }
            }
            this.addPointPROptimized(prec, recall);
            this.m_PrevTP = TP;
            this.m_PrevFP = FP;
        }
    }

    public void addPointPR(double prec, double recall) {
        double[] point = new double[]{recall, prec};
        this.m_PR.add(point);
    }

    public void addPointPROptimized(double prec, double recall) {
        int size = this.m_PR.size();
        double[] prev = this.m_PR.get(size - 1);
        if (prev[0] != recall || prev[1] != prec) {
            if (size <= 1) {
                this.addPointPR(prec, recall);
            } else {
                double[] prev2 = this.m_PR.get(size - 2);
                if (Math.abs(prev[1] - prec) < 1.0E-15 && Math.abs(prev2[1] - prec) < 1.0E-15) {
                    prev[0] = recall;
                } else if (Math.abs(prev[0] - recall) < 1.0E-15 && Math.abs(prev2[0] - recall) < 1.0E-15) {
                    prev[1] = prec;
                } else {
                    this.addPointPR(prec, recall);
                }
            }
        }
    }

    public double getPrecisionAtRecall(int j) {
        return this.m_PrecisionAtRecall[j];
    }

    public void computePrecisions(double[] recallValues) {
        if (recallValues == null) {
            return;
        }
        int nbRecalls = recallValues.length;
        this.m_PrecisionAtRecall = new double[nbRecalls];
        for (int i = 0; i < nbRecalls; ++i) {
            this.m_PrecisionAtRecall[i] = this.computePrecision(recallValues[i]);
        }
    }

    public double computePrecision(double recall) {
        return MathUtil.interpolate(recall, this.m_PR);
    }
}

