/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.MSError;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class RMSError
extends MSError {
    public static final long serialVersionUID = 1L;

    public RMSError(ClusErrorList par, NumericAttrType[] num) {
        super(par, num);
    }

    public RMSError(ClusErrorList par, NumericAttrType[] num, String info) {
        super(par, num, info);
    }

    public RMSError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights) {
        super(par, num, weights);
    }

    public RMSError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights, String info) {
        super(par, num, weights, info);
    }

    public RMSError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights, boolean printall) {
        super(par, num, weights, printall, "");
    }

    public RMSError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights, boolean printall, String info) {
        super(par, num, weights, printall, info);
    }

    @Override
    public double getModelError() {
        double sum = 0.0;
        for (int i = 0; i < this.m_Attrs.length; ++i) {
            sum += this.getModelErrorComponent(i);
        }
        return sum / (double)this.m_Attrs.length;
    }

    @Override
    public double getModelErrorComponent(int i) {
        return Math.sqrt(super.getModelErrorComponent(i));
    }

    @Override
    public void showSummaryError(PrintWriter out, boolean detail) {
        ClusNumberFormat fr = this.getFormat();
        out.println(this.getPrefix() + "Mean over components RMSE: " + fr.format(this.getModelError()));
    }

    @Override
    public String getName() {
        if (this.m_Weights == null) {
            return "Root mean squared error (RMSE)" + this.getAdditionalInfoFormatted();
        }
        return "Weighted root mean squared error (RMSE) (" + this.m_Weights.getName(this.m_Attrs) + ")" + this.getAdditionalInfoFormatted();
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new RMSError(par, this.m_Attrs, this.m_Weights, this.m_PrintAllComps, this.getAdditionalInfo());
    }
}

