/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNumericError;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class PearsonCorrelation
extends ClusNumericError
implements ComponentError {
    public static final long serialVersionUID = 1L;
    protected double[] m_SumPi;
    protected double[] m_SumSPi;
    protected double[] m_SumAi;
    protected double[] m_SumSAi;
    protected double[] m_SumPiAi;

    public PearsonCorrelation(ClusErrorList par, NumericAttrType[] num) {
        this(par, num, "");
    }

    public PearsonCorrelation(ClusErrorList par, NumericAttrType[] num, String info) {
        super(par, num);
        this.m_SumPi = new double[this.m_Dim];
        this.m_SumSPi = new double[this.m_Dim];
        this.m_SumAi = new double[this.m_Dim];
        this.m_SumSAi = new double[this.m_Dim];
        this.m_SumPiAi = new double[this.m_Dim];
        this.setAdditionalInfo(info);
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.m_Dim; ++i) {
            this.m_SumPi[i] = 0.0;
            this.m_SumSPi[i] = 0.0;
            this.m_SumAi[i] = 0.0;
            this.m_SumSAi[i] = 0.0;
            this.m_SumPiAi[i] = 0.0;
        }
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    public double getCorrelation(int i) {
        int nb = this.getNbExamples();
        double Pi_ss = this.m_SumSPi[i] - this.m_SumPi[i] * this.m_SumPi[i] / (double)nb;
        if (Pi_ss == 0.0) {
            return 0.0;
        }
        double Ai_ss = this.m_SumSAi[i] - this.m_SumAi[i] * this.m_SumAi[i] / (double)nb;
        double root = Math.sqrt(Pi_ss * Ai_ss);
        double above = this.m_SumPiAi[i] - this.m_SumPi[i] * this.m_SumAi[i] / (double)nb;
        return above / root;
    }

    @Override
    public double getModelErrorComponent(int i) {
        return this.getCorrelation(i);
    }

    @Override
    public double getModelError() {
        double mean = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            mean += this.getCorrelation(i);
        }
        return mean / (double)this.m_Dim;
    }

    @Override
    public void addExample(double[] real, double[] predicted) {
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_SumPi[n] = this.m_SumPi[n] + predicted[i];
            int n2 = i;
            this.m_SumSPi[n2] = this.m_SumSPi[n2] + predicted[i] * predicted[i];
            int n3 = i;
            this.m_SumAi[n3] = this.m_SumAi[n3] + real[i];
            int n4 = i;
            this.m_SumSAi[n4] = this.m_SumSAi[n4] + real[i] * real[i];
            int n5 = i;
            this.m_SumPiAi[n5] = this.m_SumPiAi[n5] + predicted[i] * real[i];
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        double[] predicted = pred.getNumericPred();
        for (int i = 0; i < this.m_Dim; ++i) {
            double real_i = this.getAttr(i).getNumeric(tuple);
            int n = i;
            this.m_SumPi[n] = this.m_SumPi[n] + predicted[i];
            int n2 = i;
            this.m_SumSPi[n2] = this.m_SumSPi[n2] + predicted[i] * predicted[i];
            int n3 = i;
            this.m_SumAi[n3] = this.m_SumAi[n3] + real_i;
            int n4 = i;
            this.m_SumSAi[n4] = this.m_SumSAi[n4] + real_i * real_i;
            int n5 = i;
            this.m_SumPiAi[n5] = this.m_SumPiAi[n5] + predicted[i] * real_i;
        }
    }

    @Override
    public void addExample(DataTuple real, DataTuple pred) {
        int i = 0;
        while (i < this.m_Dim) {
            double real_i = this.getAttr(i).getNumeric(real);
            double predicted_i = this.getAttr(i).getNumeric(pred);
            int n = i;
            this.m_SumPi[n] = this.m_SumPi[n] + predicted_i;
            int n2 = i;
            this.m_SumSPi[n2] = this.m_SumSPi[n2] + predicted_i * predicted_i;
            int n3 = i;
            this.m_SumAi[n3] = this.m_SumAi[n3] + real_i;
            int n4 = i;
            this.m_SumSAi[n4] = this.m_SumSAi[n4] + real_i * real_i;
            int n5 = i++;
            this.m_SumPiAi[n5] = this.m_SumPiAi[n5] + predicted_i * real_i;
        }
    }

    @Override
    public void add(ClusError other) {
        PearsonCorrelation oe = (PearsonCorrelation)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_SumPi[n] = this.m_SumPi[n] + oe.m_SumPi[i];
            int n2 = i;
            this.m_SumSPi[n2] = this.m_SumSPi[n2] + oe.m_SumSPi[i];
            int n3 = i;
            this.m_SumAi[n3] = this.m_SumAi[n3] + oe.m_SumAi[i];
            int n4 = i;
            this.m_SumSAi[n4] = this.m_SumSAi[n4] + oe.m_SumSAi[i];
            int n5 = i;
            this.m_SumPiAi[n5] = this.m_SumPiAi[n5] + oe.m_SumPiAi[i];
        }
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int nb = this.getNbExamples();
        double avg_sq_r = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            double el;
            double Pi_ss = this.m_SumSPi[i] - this.m_SumPi[i] * this.m_SumPi[i] / (double)nb;
            double Ai_ss = this.m_SumSAi[i] - this.m_SumAi[i] * this.m_SumAi[i] / (double)nb;
            if (Pi_ss <= 0.0 || Ai_ss <= 0.0) {
                el = 0.0;
            } else {
                double root = Math.sqrt(Pi_ss * Ai_ss);
                double above = this.m_SumPiAi[i] - this.m_SumPi[i] * this.m_SumAi[i] / (double)nb;
                el = above / root;
            }
            if (i != 0) {
                buf.append(",");
            }
            buf.append(fr.format(el));
            avg_sq_r += el * el;
        }
        buf.append("], Avg r^2: " + fr.format(avg_sq_r /= (double)this.m_Dim));
        out.println(buf.toString());
    }

    public boolean hasSummary() {
        return false;
    }

    @Override
    public String getName() {
        return "Pearson correlation coefficient" + this.getAdditionalInfoFormatted();
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new PearsonCorrelation(par, this.m_Attrs, this.getAdditionalInfo());
    }
}

