/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;

public class NominalCorrelation
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected int[][] m_ContTable;

    public NominalCorrelation(ClusErrorList par, NominalAttrType[] nom, int ind1, int ind2) {
        this(par, nom, ind1, ind2, "");
    }

    public NominalCorrelation(ClusErrorList par, NominalAttrType[] nom, int ind1, int ind2, String info) {
        super(par, nom);
        int size1 = this.m_Attrs[ind1].getNbValues();
        int size2 = this.m_Attrs[ind2].getNbValues();
        this.m_ContTable = new int[size1][size2];
        this.setAdditionalInfo(info);
    }

    public int calcNbCorrect(int[][] table) {
        int sum = 0;
        int size = table.length;
        for (int j = 0; j < size; ++j) {
            sum += table[j][j];
        }
        return sum;
    }

    public double calcXSquare() {
        int size1 = this.m_ContTable.length;
        int size2 = this.m_ContTable[0].length;
        int n = this.getNbExamples();
        int[] ni = new int[size1];
        int[] nj = new int[size2];
        for (int i = 0; i < size1; ++i) {
            ni[i] = this.sumJ(i);
        }
        for (int j = 0; j < size2; ++j) {
            nj[j] = this.sumI(j);
        }
        double xsquare = 0.0;
        for (int i = 0; i < size1; ++i) {
            for (int j = 0; j < size2; ++j) {
                double mij = (double)ni[i] * (double)nj[j] / (double)n;
                double err = (double)this.m_ContTable[i][j] - mij;
                if (mij == 0.0) continue;
                xsquare += err * err / mij;
            }
        }
        return xsquare;
    }

    public double calcCramerV() {
        int size1 = this.m_ContTable.length;
        int size2 = this.m_ContTable[0].length;
        int n = this.getNbExamples();
        double div = (double)n * (double)Math.min(size1 - 1, size2 - 1);
        return Math.sqrt(this.calcXSquare() / div);
    }

    public double calcMutualInfo() {
        int size1 = this.m_ContTable.length;
        int size2 = this.m_ContTable[0].length;
        int n = this.getNbExamples();
        int[] ni = new int[size1];
        int[] nj = new int[size2];
        for (int i = 0; i < size1; ++i) {
            ni[i] = this.sumJ(i);
        }
        for (int j = 0; j < size2; ++j) {
            nj[j] = this.sumI(j);
        }
        double m_info = 0.0;
        for (int i = 0; i < size1; ++i) {
            for (int j = 0; j < size2; ++j) {
                double pij = (double)this.m_ContTable[i][j] / (double)n;
                double pi = (double)ni[i] / (double)n;
                double pj = (double)nj[j] / (double)n;
                double div = pi * pj;
                if (div == 0.0) continue;
                m_info += pij * Math.log(pij / div) / Math.log(2.0);
            }
        }
        return m_info;
    }

    public int sumI(int j) {
        int sum = 0;
        int size = this.m_ContTable.length;
        for (int i = 0; i < size; ++i) {
            sum += this.m_ContTable[i][j];
        }
        return sum;
    }

    public int sumJ(int i) {
        int sum = 0;
        int size = this.m_ContTable[0].length;
        for (int j = 0; j < size; ++j) {
            sum += this.m_ContTable[i][j];
        }
        return sum;
    }

    public boolean hasSummary() {
        return false;
    }

    public void addExample(int ind1, int ind2) {
        int[] nArray = this.m_ContTable[ind1];
        int n = ind2;
        nArray[n] = nArray[n] + 1;
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new NominalCorrelation(par, this.m_Attrs, 0, 0, this.getAdditionalInfo());
    }

    @Override
    public String getName() {
        return "Cramer's V coefficient or Mutual information" + this.getAdditionalInfoFormatted();
    }

    @Override
    public boolean shouldBeLow() {
        throw new RuntimeException("should NominalCorrelation be high or low?");
    }
}

