/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.Accuracy;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class MisclassificationError
extends Accuracy {
    public static final long serialVersionUID = 1L;

    public MisclassificationError(ClusErrorList par, NominalAttrType[] nom) {
        this(par, nom, "");
    }

    public MisclassificationError(ClusErrorList par, NominalAttrType[] nom, String info) {
        super(par, nom);
        this.setAdditionalInfo(info);
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }

    @Override
    public double getModelErrorComponent(int i) {
        return 1.0 - (double)this.m_NbCorrect[i] / (double)this.getNbExamples();
    }

    @Override
    public String getName() {
        return "Misclassification error" + this.getAdditionalInfoFormatted();
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new MisclassificationError(par, this.m_Attrs, this.getAdditionalInfo());
    }

    @Override
    public double computeLeafError(ClusStatistic stat) {
        ClassificationStat cstat = (ClassificationStat)stat;
        return cstat.getError(null) * (double)cstat.getNbAttributes();
    }
}

