/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class MSNominalError
extends ClusNominalError
implements ComponentError {
    public static final long serialVersionUID = 1L;
    protected ClusAttributeWeights m_Weights;
    protected double[] m_SumErr;
    protected double[] m_SumSqErr;
    protected boolean m_PrintAllComps = true;

    public MSNominalError(ClusErrorList par, NominalAttrType[] nom, ClusAttributeWeights weights) {
        this(par, nom, weights, "");
    }

    public MSNominalError(ClusErrorList par, NominalAttrType[] nom, ClusAttributeWeights weights, String info) {
        super(par, nom);
        this.m_Weights = weights;
        this.m_SumErr = new double[this.m_Dim];
        this.m_SumSqErr = new double[this.m_Dim];
        this.setAdditionalInfo(info);
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new MSNominalError(par, this.m_Attrs, this.m_Weights, this.getAdditionalInfo());
    }

    @Override
    public String getName() {
        if (this.m_Weights == null) {
            return "Mean squared error (MSE) for Nominal Attributes" + this.getAdditionalInfoFormatted();
        }
        return "Weighted mean squared error (MSE) for Nominal Attributes (" + this.m_Weights.getName(this.m_Attrs) + ")" + this.getAdditionalInfoFormatted();
    }

    @Override
    public double getModelErrorComponent(int i) {
        double err;
        int nb = this.getNbExamples();
        double d = err = (double)nb != 0.0 ? this.m_SumErr[i] / (double)nb : 0.0;
        if (this.m_Weights != null) {
            err *= this.m_Weights.getWeight(this.getAttr(i));
        }
        return err;
    }

    @Override
    public double getModelError() {
        double ss_tree = 0.0;
        int nb = this.getNbExamples();
        if (this.m_Weights != null) {
            for (int i = 0; i < this.m_Dim; ++i) {
                ss_tree += this.m_SumErr[i] * this.m_Weights.getWeight(this.getAttr(i));
            }
            return (double)nb != 0.0 ? ss_tree / (double)nb / (double)this.m_Dim : 0.0;
        }
        for (int i = 0; i < this.m_Dim; ++i) {
            ss_tree += this.m_SumErr[i];
        }
        return (double)nb != 0.0 ? ss_tree / (double)nb / (double)this.m_Dim : 0.0;
    }

    @Override
    public double getModelErrorStandardError() {
        double sum_err = 0.0;
        double sum_sq_err = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            if (this.m_Weights != null) {
                sum_err += this.m_SumErr[i];
                sum_sq_err += this.m_SumSqErr[i];
                continue;
            }
            sum_err += this.m_SumErr[i] * this.m_Weights.getWeight(this.getAttr(i));
            sum_sq_err += this.m_SumSqErr[i] * MSNominalError.sqr(this.m_Weights.getWeight(this.getAttr(i)));
        }
        double n = this.getNbExamples() * this.m_Dim;
        if (n <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double ss_x = (n * sum_sq_err - MSNominalError.sqr(sum_err)) / (n * (n - 1.0));
        return Math.sqrt(ss_x / n);
    }

    public static final double sqr(double value) {
        return value * value;
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        ClassificationStat stat = pred.getClassificationStat();
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType type = this.m_Attrs[i];
            int value = type.getNominal(tuple);
            for (int j = 0; j < type.getNbValues(); ++j) {
                double zeroOne = value == j ? 1.0 : 0.0;
                double prop = stat.getProportion(i, j);
                double err = MSNominalError.sqr(zeroOne - prop);
                int n = i;
                this.m_SumErr[n] = this.m_SumErr[n] + err;
                int n2 = i;
                this.m_SumSqErr[n2] = this.m_SumSqErr[n2] + MSNominalError.sqr(err);
            }
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.m_Dim; ++i) {
            this.m_SumErr[i] = 0.0;
            this.m_SumSqErr[i] = 0.0;
        }
    }

    @Override
    public void add(ClusError other) {
        MSNominalError oe = (MSNominalError)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_SumErr[n] = this.m_SumErr[n] + oe.m_SumErr[i];
            int n2 = i;
            this.m_SumSqErr[n2] = this.m_SumSqErr[n2] + oe.m_SumSqErr[i];
        }
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        if (this.m_PrintAllComps) {
            buf.append("[");
            for (int i = 0; i < this.m_Dim; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(fr.format(this.getModelErrorComponent(i)));
            }
            if (this.m_Dim > 1) {
                buf.append("]: ");
            } else {
                buf.append("]");
            }
        }
        if (this.m_Dim > 1 || !this.m_PrintAllComps) {
            buf.append(fr.format(this.getModelError()));
        }
        out.println(buf.toString());
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        ClusNumberFormat fr = this.getFormat();
        out.println(this.getPrefix() + "Mean over components MSE: " + fr.format(this.getModelError()));
    }

    @Override
    public double computeLeafError(ClusStatistic stat) {
        ClassificationStat cstat = (ClassificationStat)stat;
        return cstat.getSVarS(this.m_Weights) * (double)cstat.getNbAttributes();
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }
}

