/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.util.exception.ClusException;

public class ICVPairwiseDistancesError
extends ClusError {
    public static final long serialVersionUID = 1L;
    protected double m_Value;
    protected double m_ValueWithDefault;
    protected ClusDistance m_Dist;

    public ICVPairwiseDistancesError(ClusErrorList par, ClusDistance dist) {
        this(par, dist, "");
    }

    public ICVPairwiseDistancesError(ClusErrorList par, ClusDistance dist, String info) {
        super(par);
        this.m_Dist = dist;
        this.setAdditionalInfo(info);
    }

    public static double computeICVPairwiseDistances(ClusDistance dist, RowData data) throws ClusException {
        double sum = 0.0;
        double sumWiDiag = 0.0;
        double sumWiTria = 0.0;
        int nb = data.getNbRows();
        for (int j = 0; j < nb; ++j) {
            DataTuple t1 = data.getTuple(j);
            double w1 = t1.getWeight();
            for (int i = 0; i < j; ++i) {
                DataTuple t2 = data.getTuple(i);
                double wi = w1 * t2.getWeight();
                double d = dist.calcDistance(t1, t2);
                sum += wi * d;
                sumWiTria += wi;
            }
            sumWiDiag += w1 * w1;
        }
        return sum / (2.0 * sumWiTria + sumWiDiag);
    }

    public void computeRecursive(ClusNode node, RowData data) throws ClusException {
        int nb = node.getNbChildren();
        if (nb == 0) {
            double variance = ICVPairwiseDistancesError.computeICVPairwiseDistances(this.m_Dist, data);
            double sumweight = data.getSumWeights();
            this.m_Value += sumweight * variance;
        } else {
            NodeTest tst = node.getTest();
            for (int i = 0; i < node.getNbChildren(); ++i) {
                ClusNode child = (ClusNode)node.getChild(i);
                RowData subset = data.applyWeighted(tst, i);
                this.computeRecursive(child, subset);
            }
        }
    }

    public void computeForRule(ClusRule rule, ClusSchema schema) throws ClusException {
        RowData covered = new RowData(rule.getData(), schema);
        this.m_Value = ICVPairwiseDistancesError.computeICVPairwiseDistances(this.m_Dist, covered);
    }

    public void computeForRuleSet(ClusRuleSet set, ClusSchema schema) throws ClusException {
        double sumWeight = 0.0;
        for (int i = 0; i < set.getModelSize(); ++i) {
            RowData covered = new RowData(set.getRule(i).getData(), schema);
            double weight = covered.getSumWeights();
            this.m_Value += weight * ICVPairwiseDistancesError.computeICVPairwiseDistances(this.m_Dist, covered);
            sumWeight += weight;
        }
        this.m_ValueWithDefault = this.m_Value;
        this.m_Value /= sumWeight;
        RowData defaultData = new RowData(set.getDefaultData(), schema);
        double defWeight = defaultData.getSumWeights();
        this.m_ValueWithDefault += defWeight * ICVPairwiseDistancesError.computeICVPairwiseDistances(this.m_Dist, defaultData);
        this.m_ValueWithDefault /= (sumWeight += defWeight);
    }

    @Override
    public void compute(RowData data, ClusModel model) throws ClusException {
        if (model instanceof ClusNode) {
            ClusNode tree = (ClusNode)model;
            this.computeRecursive(tree, data);
            this.m_Value /= data.getSumWeights();
        } else if (model instanceof ClusRuleSet) {
            this.computeForRuleSet((ClusRuleSet)model, data.getSchema());
        } else if (model instanceof ClusRule) {
            this.computeForRule((ClusRule)model, data.getSchema());
        }
    }

    @Override
    public void showModelError(PrintWriter wrt, int detail) {
        StringBuffer res = new StringBuffer();
        res.append(String.valueOf(this.m_Value));
        if (this.m_ValueWithDefault != 0.0) {
            res.append(" (with default: " + this.m_ValueWithDefault + ")");
        }
        wrt.println(res.toString());
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new ICVPairwiseDistancesError(this.getParent(), this.m_Dist, this.getAdditionalInfo());
    }

    @Override
    public String getName() {
        return "ICV-Pairwise-Distances" + this.getAdditionalInfoFormatted();
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }
}

