/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.NominalCorrelation;
import si.ijs.kt.clus.error.PearsonCorrelation;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.format.ClusFormat;

public class CorrelationMatrixComputer {
    PearsonCorrelation[][] m_MatrixPC;
    NominalCorrelation[][] m_MatrixNC;
    boolean m_IsRegression = true;

    public void compute(RowData data) {
        if (data.getSchema().isRegression()) {
            this.computeNum(data);
        } else {
            this.m_IsRegression = false;
            this.computeNom(data);
        }
    }

    public void computeNum(RowData data) {
        ClusSchema schema = data.getSchema();
        NumericAttrType[] attrs = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        int nb_num = attrs.length;
        this.m_MatrixPC = new PearsonCorrelation[nb_num][nb_num];
        NumericAttrType[] crtype = new NumericAttrType[]{new NumericAttrType("corr")};
        ClusErrorList par = new ClusErrorList();
        for (int i = 0; i < nb_num; ++i) {
            for (int j = 0; j < nb_num; ++j) {
                this.m_MatrixPC[i][j] = new PearsonCorrelation(par, crtype);
            }
        }
        double[] a1 = new double[1];
        double[] a2 = new double[1];
        par.setNbExamples(data.getNbRows());
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            for (int j = 0; j < nb_num; ++j) {
                for (int k = 0; k < nb_num; ++k) {
                    a1[0] = attrs[j].getNumeric(tuple);
                    a2[0] = attrs[k].getNumeric(tuple);
                    this.m_MatrixPC[j][k].addExample(a1, a2);
                }
            }
        }
    }

    public void computeNom(RowData data) {
        ClusSchema schema = data.getSchema();
        NominalAttrType[] attrs = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        int nb_nom = attrs.length;
        this.m_MatrixNC = new NominalCorrelation[nb_nom][nb_nom];
        ClusErrorList par = new ClusErrorList();
        for (int i = 0; i < nb_nom; ++i) {
            for (int j = 0; j < nb_nom; ++j) {
                this.m_MatrixNC[i][j] = new NominalCorrelation(par, attrs, i, j);
            }
        }
        par.setNbExamples(data.getNbRows());
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            for (int j = 0; j < nb_nom; ++j) {
                for (int k = 0; k < nb_nom; ++k) {
                    int a1 = attrs[j].getNominal(tuple);
                    int a2 = attrs[k].getNominal(tuple);
                    this.m_MatrixNC[j][k].addExample(a1, a2);
                }
            }
        }
    }

    public void printMatrixTeX() {
        int i;
        int nb_tar;
        if (this.m_IsRegression) {
            nb_tar = this.m_MatrixPC.length;
            ClusLogger.info("Number of numeric: " + nb_tar);
        } else {
            nb_tar = this.m_MatrixNC.length;
            ClusLogger.info("Number of nominal: " + nb_tar);
        }
        ClusLogger.info();
        System.out.print("\\begin{tabular}{");
        for (i = 0; i < nb_tar + 2; ++i) {
            System.out.print("l");
        }
        ClusLogger.info("}");
        for (i = 0; i < nb_tar; ++i) {
            System.out.print(" & " + (i + 1));
        }
        ClusLogger.info("& Avg.");
        ClusLogger.info("\\\\");
        int nb_pairs = 0;
        double pairs_sum = 0.0;
        for (int i2 = 0; i2 < nb_tar; ++i2) {
            System.out.print(i2 + 1);
            double avg = 0.0;
            double cnt = 0.0;
            for (int j = 0; j < nb_tar; ++j) {
                double corr = this.m_IsRegression ? this.m_MatrixPC[i2][j].getCorrelation(0) : this.m_MatrixNC[i2][j].calcMutualInfo();
                if (i2 != j) {
                    avg += corr;
                    cnt += 1.0;
                }
                if (i2 > j) {
                    pairs_sum += corr;
                    ++nb_pairs;
                }
                System.out.print(" & " + ClusFormat.THREE_AFTER_DOT.format(corr));
            }
            System.out.print(" & " + ClusFormat.THREE_AFTER_DOT.format(avg / cnt));
            ClusLogger.info("\\\\");
        }
        System.out.print("\\multicolumn{" + (nb_tar + 2) + "}{l}{Pairwise average:");
        if (nb_pairs > 0) {
            ClusLogger.info(" " + ClusFormat.THREE_AFTER_DOT.format(pairs_sum / (double)nb_pairs) + "}");
        } else {
            ClusLogger.info(" Undefined}");
        }
        ClusLogger.info("\\end{tabular}");
    }
}

