/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import si.ijs.kt.clus.util.jeans.util.compound.DoubleBooleanCount;

public class BinaryPredictionList
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected int m_NbPos;
    protected int m_NbNeg;
    protected transient ArrayList<DoubleBooleanCount> m_Values = new ArrayList();
    protected transient HashMap<DoubleBooleanCount, DoubleBooleanCount> m_ValueSet = new HashMap();

    public void addExample(boolean actual, double predicted) {
        DoubleBooleanCount value = new DoubleBooleanCount(predicted, actual);
        DoubleBooleanCount prevValue = this.m_ValueSet.get(value);
        if (prevValue != null) {
            prevValue.inc();
        } else {
            this.m_ValueSet.put(value, value);
        }
        if (actual) {
            ++this.m_NbPos;
        } else {
            ++this.m_NbNeg;
        }
    }

    public void addInvalid(boolean actual) {
        if (actual) {
            ++this.m_NbPos;
        } else {
            ++this.m_NbNeg;
        }
    }

    public void sort() {
        this.m_Values.clear();
        this.m_Values.addAll(this.m_ValueSet.values());
        Collections.sort(this.m_Values);
    }

    public int size() {
        return this.m_Values.size();
    }

    public DoubleBooleanCount get(int i) {
        return this.m_Values.get(i);
    }

    public void clear() {
        this.m_NbPos = 0;
        this.m_NbNeg = 0;
        this.m_Values.clear();
        this.m_ValueSet.clear();
    }

    public void clearData() {
        this.m_Values.clear();
    }

    public int getNbPos() {
        return this.m_NbPos;
    }

    public int getNbNeg() {
        return this.m_NbNeg;
    }

    public double getFrequency() {
        return (double)this.m_NbPos / (double)(this.m_NbPos + this.m_NbNeg);
    }

    public boolean hasBothPosAndNegEx() {
        return this.m_NbPos != 0 && this.m_NbNeg != 0;
    }

    public void add(BinaryPredictionList other) {
        this.m_NbPos += other.getNbPos();
        this.m_NbNeg += other.getNbNeg();
        for (DoubleBooleanCount otherValue : other.m_ValueSet.values()) {
            DoubleBooleanCount myValue = this.m_ValueSet.get(otherValue);
            if (myValue != null) {
                myValue.inc(otherValue);
                continue;
            }
            DoubleBooleanCount newValue = new DoubleBooleanCount(otherValue);
            this.m_ValueSet.put(newValue, newValue);
        }
    }

    public void copyActual(BinaryPredictionList other) {
        this.m_NbPos = other.getNbPos();
        this.m_NbNeg = other.getNbNeg();
    }
}

