/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class AvgDistancesError
extends ClusError {
    public static final long serialVersionUID = 1L;
    protected double m_SumErr;
    protected ClusDistance m_Distance;

    public AvgDistancesError(ClusErrorList par, ClusDistance dist) {
        this(par, dist, "");
    }

    public AvgDistancesError(ClusErrorList par, ClusDistance dist, String info) {
        super(par);
        this.m_Distance = dist;
        this.setAdditionalInfo(info);
    }

    @Override
    public void reset() {
        this.m_SumErr = 0.0;
    }

    @Override
    public void add(ClusError other) {
        AvgDistancesError oe = (AvgDistancesError)other;
        this.m_SumErr += oe.m_SumErr;
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) throws ClusException {
        this.m_SumErr += this.m_Distance.calcDistanceToCentroid(tuple, pred);
    }

    @Override
    public double getModelErrorAdditive() {
        return this.m_SumErr;
    }

    @Override
    public double getModelError() {
        return this.getModelErrorComponent(0);
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new AvgDistancesError(par, this.m_Distance, this.getAdditionalInfo());
    }

    @Override
    public void showModelError(PrintWriter wrt, int detail) {
        StringBuffer res = new StringBuffer();
        res.append(String.valueOf(this.getModelError()));
        wrt.println(res.toString());
    }

    @Override
    public String getName() {
        return "AvgDistancesError" + this.getAdditionalInfoFormatted();
    }

    @Override
    public double getModelErrorComponent(int i) {
        int nb = this.getNbExamples();
        double err = nb != 0 ? this.m_SumErr / (double)nb : 0.0;
        return err;
    }
}

