/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.primitive.timeseries;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;
import si.ijs.kt.clus.ext.timeseries.TimeSeriesStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class TimeSeriesDist
extends ClusDistance {
    public static final long serialVersionUID = 1L;
    protected TimeSeriesAttrType m_Attr;

    public TimeSeriesDist(TimeSeriesAttrType attr) {
        this.m_Attr = attr;
    }

    public abstract double calcDistance(TimeSeries var1, TimeSeries var2) throws ClusException;

    @Override
    public double calcDistance(Object t1, Object t2) throws ClusException {
        return this.calcDistance((TimeSeries)t1, (TimeSeries)t2);
    }

    @Override
    public double calcDistance(DataTuple t1, DataTuple t2) throws ClusException {
        TimeSeries ts1 = this.m_Attr.getTimeSeries(t1);
        TimeSeries ts2 = this.m_Attr.getTimeSeries(t2);
        return this.calcDistance(ts1, ts2);
    }

    @Override
    public double calcDistanceToCentroid(DataTuple t1, ClusStatistic s2) throws ClusException {
        TimeSeries ts1 = this.m_Attr.getTimeSeries(t1);
        TimeSeriesStat stat = (TimeSeriesStat)s2;
        return this.calcDistance(ts1, stat.getRepresentativeMedoid());
    }
}

