/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.primitive.timeseries;

import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.primitive.timeseries.TimeSeriesDist;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;

public class QDMTimeSeriesDist
extends TimeSeriesDist {
    public static final long serialVersionUID = 1L;

    public QDMTimeSeriesDist(TimeSeriesAttrType attr) {
        super(attr);
    }

    @Override
    public double calcDistance(TimeSeries t1, TimeSeries t2) {
        double[] vt1 = t1.getValuesNoCopy();
        double[] vt2 = t2.getValuesNoCopy();
        int m = Math.max(vt1.length, vt2.length);
        int n = Math.min(vt1.length, vt2.length);
        double distance = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = i + 1; j < m; ++j) {
                distance += (double)Math.abs(QDMTimeSeriesDist.diff(vt1[j], vt1[i]) - QDMTimeSeriesDist.diff(vt2[j % n], vt2[i % n]));
            }
        }
        return distance /= (double)(m * (m - 1));
    }

    public static int diff(double a, double b) {
        if (a == 0.0 && b == 0.0) {
            return 0;
        }
        if (b != 0.0 && Math.abs(a / b - 1.0) < 0.02) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String getDistanceName() {
        return "QDMTimeSeriesDist";
    }
}

