/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.primitive.relief;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.hierarchies.ClassesAttrType;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.util.jeans.math.MathUtil;

public class HierarchicalMultiLabelDistance {
    private HashMap<String, ClassHierarchy> m_Hierarchies = new HashMap();
    private HashMap<String, Double> m_HierarUpperBounds = new HashMap();

    public void processAttribute(ClassesAttrType attr, RowData data) {
        String attrName = attr.getName();
        this.m_Hierarchies.put(attrName, attr.getHier());
        boolean[][] presentAndFinal = HierarchicalMultiLabelDistance.getPresentTerms(attr.getHier(), data);
        double upperDistanceBound = this.upperBound(attr, presentAndFinal);
        this.m_HierarUpperBounds.put(attrName, upperDistanceBound);
    }

    public double calculateDist(DataTuple t1, DataTuple t2, ClassesAttrType attr) {
        int labelIndex;
        int j;
        String name = attr.getName();
        ClassHierarchy hier = this.m_Hierarchies.get(name);
        int sidx = hier.getType().getArrayIndex();
        ClassesTuple tp1 = (ClassesTuple)t1.getObjVal(sidx);
        ClassesTuple tp2 = (ClassesTuple)t2.getObjVal(sidx);
        HashSet<Integer> symmetricDifferenceOfLabelSets = new HashSet<Integer>();
        for (j = 0; j < tp1.getNbClasses(); ++j) {
            labelIndex = tp1.getClass(j).getIndex();
            symmetricDifferenceOfLabelSets.add(labelIndex);
        }
        for (j = 0; j < tp2.getNbClasses(); ++j) {
            labelIndex = tp2.getClass(j).getIndex();
            if (symmetricDifferenceOfLabelSets.contains(labelIndex)) {
                symmetricDifferenceOfLabelSets.remove(labelIndex);
                continue;
            }
            symmetricDifferenceOfLabelSets.add(labelIndex);
        }
        double dist = this.weightedEuclideanInt(hier, symmetricDifferenceOfLabelSets);
        return dist / this.m_HierarUpperBounds.get(name);
    }

    private static void computeDepthsOfTerms(ClassHierarchy hier) {
        ArrayList<ClassTerm> toProcess = new ArrayList<ClassTerm>();
        HashMap<ClassTerm, Integer> numberOfProcessedParents = new HashMap<ClassTerm, Integer>();
        for (int i = 0; i < hier.getTotal(); ++i) {
            ClassTerm term = hier.getTermAt(i);
            numberOfProcessedParents.put(term, term.getNbParents());
            if ((Integer)numberOfProcessedParents.get(term) != 0) continue;
            toProcess.add(term);
        }
        toProcess.add(hier.getRoot());
        while (toProcess.size() > 0) {
            ClassTerm term = (ClassTerm)toProcess.remove(toProcess.size() - 1);
            if (term.getNbParents() == 0) {
                term.setDepth(-1.0);
            } else {
                double avgDepth = 0.0;
                for (int i = 0; i < term.getNbParents(); ++i) {
                    avgDepth += term.getParent(i).getDepth();
                }
                term.setDepth((avgDepth /= (double)term.getNbParents()) + 1.0);
            }
            for (int i = 0; i < term.getNbChildren(); ++i) {
                ClassTerm child = (ClassTerm)term.getChild(i);
                int nbParentsToProcess = (Integer)numberOfProcessedParents.get(child);
                if (nbParentsToProcess == 1) {
                    toProcess.add(child);
                }
                numberOfProcessedParents.put(child, nbParentsToProcess - 1);
            }
        }
    }

    private static boolean[][] getPresentTerms(ClassHierarchy hier, RowData data) {
        int hierarchySize = hier.getTotal();
        boolean[] present = new boolean[hierarchySize];
        boolean[] finalClasses = new boolean[hierarchySize];
        int nbFinal = 0;
        int sidx = hier.getType().getArrayIndex();
        boolean isTree = hier.isTree();
        for (int i = 0; i < data.getNbRows(); ++i) {
            ClassesTuple tp = (ClassesTuple)data.getTuple(i).getObjVal(sidx);
            int nbClasses = tp.getNbClasses();
            if (nbClasses == 0) continue;
            int lastClassIndex = -123;
            lastClassIndex = isTree ? tp.getClass(nbClasses - 1).getIndex() : HierarchicalMultiLabelDistance.mostSpecificTermIndex(tp);
            if (!finalClasses[lastClassIndex]) {
                finalClasses[lastClassIndex] = true;
                ++nbFinal;
            }
            if (present[lastClassIndex]) continue;
            for (int j = 0; j < nbClasses; ++j) {
                int ind = tp.getClass(j).getIndex();
                if (present[ind]) continue;
                present[ind] = true;
            }
        }
        return new boolean[][]{present, finalClasses, {nbFinal > 1}};
    }

    private double upperBound(ClassesAttrType attr, boolean[][] presentAndFinalClasses) {
        boolean atLeastTwoClasses = presentAndFinalClasses[2][0];
        if (atLeastTwoClasses) {
            ClassHierarchy hier = this.m_Hierarchies.get(attr.getName());
            if (hier.isTree()) {
                return this.upperBoundTree(hier, presentAndFinalClasses[0], presentAndFinalClasses[1]);
            }
            return this.upperBoundDAG(hier, presentAndFinalClasses[0], presentAndFinalClasses[1]);
        }
        return 1.0;
    }

    private double upperBoundTree(ClassHierarchy hier, boolean[] presentClasses, boolean[] finalClasses) {
        HierarchicalMultiLabelDistance.computeDepthsOfTerms(hier);
        double bound = 0.0;
        ClassTerm root = hier.getRoot();
        ArrayList<ClassTerm> extremeTerms = this.findDistantTerms(hier, root, presentClasses, finalClasses);
        bound = this.weightedEuclidean(hier, extremeTerms.get(0), extremeTerms.get(1));
        return bound;
    }

    private double upperBoundDAG(ClassHierarchy hier, boolean[] presentClasses, boolean[] finalClasses) {
        ArrayList<Integer> finalClassesOnly = new ArrayList<Integer>();
        for (int termInd = 0; termInd < finalClasses.length; ++termInd) {
            if (!finalClasses[termInd]) continue;
            finalClassesOnly.add(termInd);
        }
        double bound = 0.0;
        for (int i = 0; i < finalClassesOnly.size(); ++i) {
            ClassTerm term1 = hier.getTermAt((Integer)finalClassesOnly.get(i));
            for (int j = i + 1; j < finalClassesOnly.size(); ++j) {
                ClassTerm term2 = hier.getTermAt((Integer)finalClassesOnly.get(j));
                double dist = this.weightedEuclidean(hier, term1, term2);
                if (!(dist > bound + 1.0E-9)) continue;
                bound = dist;
            }
        }
        return bound;
    }

    private ArrayList<ClassTerm> findDistantTerms(ClassHierarchy hier, ClassTerm root, boolean[] presentClasses, boolean[] finalClasses) {
        ArrayList<ClassTerm> extremeTerms = new ArrayList<ClassTerm>();
        int rootInd = root.getIndex();
        if (rootInd >= 0 && !presentClasses[rootInd]) {
            return extremeTerms;
        }
        ArrayList<ArrayList<ClassTerm>> childrenResults = new ArrayList<ArrayList<ClassTerm>>();
        int nbCh = root.getNbChildren();
        for (int i = 0; i < nbCh; ++i) {
            ArrayList<ClassTerm> resultCh = this.findDistantTerms(hier, (ClassTerm)root.getChild(i), presentClasses, finalClasses);
            if (resultCh.size() <= 0) continue;
            childrenResults.add(resultCh);
        }
        boolean rootIsApproprite = rootInd >= 0 && finalClasses[rootInd];
        int nbChildrenCandidates = childrenResults.size();
        int notAnIndex = -1234;
        int[] inds = new int[]{notAnIndex, notAnIndex};
        for (int i = 0; i < nbChildrenCandidates; ++i) {
            int whereTo;
            double thisDepth = ((ClassTerm)((ArrayList)childrenResults.get(i)).get(0)).getDepth();
            for (whereTo = 0; whereTo < inds.length && inds[whereTo] != notAnIndex && !(thisDepth > ((ClassTerm)((ArrayList)childrenResults.get(inds[whereTo])).get(0)).getDepth() + 1.0E-6); ++whereTo) {
            }
            for (int worseItemInd = inds.length - 2; worseItemInd >= whereTo; --worseItemInd) {
                inds[worseItemInd + 1] = inds[worseItemInd];
            }
            if (whereTo >= inds.length) continue;
            inds[whereTo] = i;
        }
        if (nbChildrenCandidates == 0) {
            if (rootIsApproprite) {
                extremeTerms.add(root);
            }
        } else if (nbChildrenCandidates == 1) {
            extremeTerms.add((ClassTerm)((ArrayList)childrenResults.get(0)).get(0));
            if (((ArrayList)childrenResults.get(0)).size() == 1 && rootIsApproprite) {
                extremeTerms.add(root);
            } else if (((ArrayList)childrenResults.get(0)).size() == 2 && rootIsApproprite) {
                double distChildComb;
                double distChildRootComb = this.weightedEuclidean(hier, (ClassTerm)((ArrayList)childrenResults.get(0)).get(0), root);
                if (distChildRootComb > (distChildComb = this.weightedEuclidean(hier, (ClassTerm)((ArrayList)childrenResults.get(0)).get(0), (ClassTerm)((ArrayList)childrenResults.get(0)).get(1)))) {
                    extremeTerms.add(root);
                } else {
                    extremeTerms.add((ClassTerm)((ArrayList)childrenResults.get(0)).get(1));
                }
            } else if (((ArrayList)childrenResults.get(0)).size() == 2) {
                extremeTerms.add((ClassTerm)((ArrayList)childrenResults.get(0)).get(1));
            }
        } else {
            double maxDistDiffChildren = this.weightedEuclidean(hier, (ClassTerm)((ArrayList)childrenResults.get(inds[0])).get(0), (ClassTerm)((ArrayList)childrenResults.get(inds[1])).get(0));
            double maxInnerDistChild = 0.0;
            int optimal = -1;
            for (int i = 0; i < nbChildrenCandidates; ++i) {
                double dist;
                if (((ArrayList)childrenResults.get(i)).size() <= 1 || !((dist = this.weightedEuclidean(hier, (ClassTerm)((ArrayList)childrenResults.get(i)).get(0), (ClassTerm)((ArrayList)childrenResults.get(i)).get(1))) > maxInnerDistChild + 1.0E-9)) continue;
                optimal = i;
                maxInnerDistChild = dist;
            }
            if (maxDistDiffChildren > maxInnerDistChild) {
                extremeTerms.add((ClassTerm)((ArrayList)childrenResults.get(inds[0])).get(0));
                extremeTerms.add((ClassTerm)((ArrayList)childrenResults.get(inds[1])).get(0));
            } else {
                extremeTerms.addAll((Collection)childrenResults.get(optimal));
            }
        }
        return extremeTerms;
    }

    private double weightedEuclideanInt(ClassHierarchy hier, HashSet<Integer> symmetricDifferenceOfLabelSets) {
        double dist = 0.0;
        for (int labelIndex : symmetricDifferenceOfLabelSets) {
            dist += hier.getWeight(labelIndex);
        }
        return dist;
    }

    private double weightedEuclideanTerm(ClassHierarchy hier, HashSet<ClassTerm> symmetricDifferenceOfLabelSets) {
        double dist = 0.0;
        for (ClassTerm term : symmetricDifferenceOfLabelSets) {
            dist += hier.getWeight(term.getIndex());
        }
        return dist;
    }

    private double weightedEuclidean(ClassHierarchy hier, ClassTerm finalTerm1, ClassTerm finalTerm2) {
        return this.weightedEuclideanTerm(hier, MathUtil.symmetricDifference(finalTerm1.getAllAncestors(true), finalTerm2.getAllAncestors(true)));
    }

    private static int mostSpecificTermIndex(ClassesTuple tp) {
        int ind = 0;
        HashMap<Integer, Integer> termIndices = new HashMap<Integer, Integer>();
        int nbClasses = tp.getNbClasses();
        for (int i = 0; i < nbClasses; ++i) {
            termIndices.put(tp.getClass(i).getIndex(), i);
        }
        boolean continueSearch = true;
        block1: while (continueSearch) {
            continueSearch = false;
            ClassTerm term = tp.getClass(ind).getTerm();
            if (term.atBottomLevel()) {
                return term.getIndex();
            }
            for (int i = 0; i < term.getNbChildren(); ++i) {
                int j = ((ClassTerm)term.getChild(i)).getIndex();
                if (!termIndices.containsKey(j)) continue;
                ind = (Integer)termIndices.get(j);
                continueSearch = true;
                continue block1;
            }
        }
        return tp.getClass(ind).getIndex();
    }

    @Deprecated
    private double getWeight(ClassHierarchy hier) {
        double[] weights = hier.getWeights();
        double maxW = 0.0;
        for (double w : weights) {
            if (!(w < 0.999999) || !(w > maxW)) continue;
            maxW = w;
        }
        return maxW;
    }
}

