/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.primitive;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.util.exception.ClusException;

public class SearchDistance
extends ClusDistance {
    private static final long serialVersionUID = 1L;
    private ClusDistance m_Distance;
    public double[] m_MinValues = null;
    public double[] m_NormalizationWeights = null;

    public void setDistance(ClusDistance dist) {
        this.m_Distance = dist;
    }

    public void setNormalizationWeights(double[] min_values, double[] max_values) {
        this.m_MinValues = new double[min_values.length];
        this.m_NormalizationWeights = new double[min_values.length];
        for (int i = 0; i < this.m_NormalizationWeights.length; ++i) {
            this.m_MinValues[i] = min_values[i];
            this.m_NormalizationWeights[i] = max_values[i] != min_values[i] ? 1.0 / (max_values[i] - min_values[i]) : 3.14159;
        }
    }

    @Override
    public double calcDistance(DataTuple t1, DataTuple t2) throws ClusException {
        return this.m_Distance.calcDistance(t1, t2);
    }

    public double calcDistanceOnAttr(DataTuple t1, DataTuple t2, ClusAttrType attr) {
        if (attr instanceof NumericAttrType) {
            if (attr.isMissing(t2)) {
                if (attr.isMissing(t1)) {
                    return 1.0;
                }
                double t = (attr.getNumeric(t1) - this.m_MinValues[attr.getIndex()]) * this.m_NormalizationWeights[attr.getIndex()];
                return Math.max(t, 1.0 - t);
            }
            if (attr.isMissing(t1)) {
                double t = (attr.getNumeric(t2) - this.m_MinValues[attr.getIndex()]) * this.m_NormalizationWeights[attr.getIndex()];
                return Math.max(t, 1.0 - t);
            }
            return Math.abs(attr.getNumeric(t2) - attr.getNumeric(t1)) * this.m_NormalizationWeights[attr.getIndex()];
        }
        if (attr instanceof NominalAttrType) {
            return attr.getNominal(t2) == attr.getNominal(t1) && !attr.isMissing(t2) && !attr.isMissing(t1) ? 0.0 : 1.0;
        }
        throw new IllegalArgumentException(this.getClass().getName() + ":calcDistanceOnAttr() - Distance not supported!");
    }

    public double getValue(DataTuple t1, ClusAttrType attr) {
        throw new RuntimeException("We do not trust SearchDistance.getValue method yet.");
    }

    @Override
    public ClusDistance getBasicDistance() {
        return this.m_Distance;
    }

    @Override
    public String getDistanceName() {
        return "Search distance";
    }
}

