/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.primitive;

import java.util.HashSet;
import java.util.Set;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.primitive.SearchDistance;

public class ManhattanDistance
extends ClusDistance {
    private static final long serialVersionUID = 1L;
    private SearchDistance m_Search;

    public ManhattanDistance(SearchDistance search, boolean isSparse, ClusAttrType[] necessaryDescriptiveAttributes) {
        this.m_Search = search;
        this.m_IsSparse = isSparse;
        this.m_Attributes = necessaryDescriptiveAttributes;
    }

    @Override
    public double calcDistance(DataTuple t1, DataTuple t2) {
        double dist = 0.0;
        if (this.m_IsSparse) {
            for (ClusAttrType attr : this.m_Attributes) {
                dist += Math.pow(this.m_Search.calcDistanceOnAttr(t1, t2, attr), 2.0) * this.m_AttrWeighting.getWeight(attr);
            }
            Set<Integer> inds1 = ((SparseDataTuple)t1).getAttributeIndicesSet();
            Set<Integer> inds2 = ((SparseDataTuple)t2).getAttributeIndicesSet();
            HashSet<Integer> inds = new HashSet<Integer>(inds1);
            inds.addAll(inds2);
            for (int ind : inds) {
                ClusAttrType attr;
                attr = t1.getSchema().getAttrType(ind);
                dist += this.m_Search.calcDistanceOnAttr(t1, t2, attr) * this.m_AttrWeighting.getWeight(attr);
            }
        } else {
            for (ClusAttrType attr : t1.getSchema().getAllAttrUse(ClusAttrType.AttributeUseType.Descriptive)) {
                dist += this.m_Search.calcDistanceOnAttr(t1, t2, attr) * this.m_AttrWeighting.getWeight(attr);
            }
        }
        return dist;
    }

    @Override
    public String getDistanceName() {
        return "Manhattan distance";
    }
}

