/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.hierarchies;

import si.ijs.kt.clus.distance.hierarchies.HierBasicDistance;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;

public class HierWeightSPath
implements HierBasicDistance {
    protected double[] m_Weights;
    protected double m_RootDelta = 1.0;
    protected double fac;

    public HierWeightSPath(int depth, double fac) {
        this.fac = fac;
        this.m_Weights = new double[depth];
        for (int i = 0; i < depth; ++i) {
            this.m_Weights[i] = Math.pow(fac, i);
        }
    }

    protected final double getFac() {
        return this.fac;
    }

    protected final double getWeight(int level) {
        return this.m_Weights[level];
    }

    @Override
    public double getVirtualRootWeight() {
        return this.m_RootDelta;
    }

    @Override
    public double calcDistance(ClassTerm t1, ClassTerm t2) {
        int d1;
        double distance = 0.0;
        int d2 = t2.getLevel();
        int com_d = Math.min(d1, d2);
        for (d1 = t1.getLevel(); d1 > com_d; --d1) {
            distance += this.getWeight(d1);
            t1 = t1.getCTParent();
        }
        while (d2 > com_d) {
            distance += this.getWeight(d2);
            t2 = t2.getCTParent();
            --d2;
        }
        while (t1 != t2) {
            distance += 2.0 * this.getWeight(com_d);
            t1 = t1.getCTParent();
            t2 = t2.getCTParent();
            --com_d;
        }
        return distance;
    }
}

