/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.complex.tuples;

import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.complex.TupleAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.complex.TupleDistance;
import si.ijs.kt.clus.ext.structuredTypes.Tuple;
import si.ijs.kt.clus.util.exception.ClusException;

public class MinkowskiDistance
extends TupleDistance {
    private static final long serialVersionUID = 1L;
    private int m_Order = 2;

    public MinkowskiDistance(TupleAttrType attr, int order, ClusDistance[] distances) {
        super(attr);
        this.m_Order = order;
        this.m_ChildDistances = distances;
    }

    public MinkowskiDistance(int order, ClusDistance[] distances) {
        super(null);
        this.m_Order = order;
        this.m_ChildDistances = distances;
    }

    @Override
    public double calcDistance(Object t1, Object t2) throws ClusException {
        return this.calcDistance((Tuple)t1, (Tuple)t2);
    }

    @Override
    public double calcDistance(Tuple t1, Tuple t2) throws ClusException {
        double distance = 0.0;
        if (!Double.isInfinite(this.m_Order)) {
            int i = 0;
            ClusAttrType[] types = this.m_Attr.getInnerTypes();
            for (Object element : t1.getValues()) {
                Object element1 = t2.getValue(i);
                if (types[i] instanceof NumericAttrType) {
                    distance += Math.pow((Double)element - (Double)element1, this.m_Order);
                } else if (element != null && element1 != null) {
                    distance += Math.pow(this.m_ChildDistances[i].calcDistance(element, element1), this.m_Order);
                }
                ++i;
            }
        } else {
            throw new UnsupportedOperationException("clus.ext.tuples.distances.MinkowskiDistance.calcDistance(Tuple, Tuple); m_Order == Infinity");
        }
        distance = Math.pow(distance, 1.0 / (double)this.m_Order);
        return distance;
    }

    @Override
    public String getDistanceName() {
        return "Minkowski distance (tuples)";
    }
}

