/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.complex.sets;

import si.ijs.kt.clus.data.type.complex.SetAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.complex.SetDistance;
import si.ijs.kt.clus.ext.structuredTypes.Set;
import si.ijs.kt.clus.util.exception.ClusException;

public class JaccardDistance
extends SetDistance {
    private static final long serialVersionUID = 1L;

    public JaccardDistance(SetAttrType attr, ClusDistance innerDistance) {
        super(attr, innerDistance);
    }

    public JaccardDistance(ClusDistance innerDistance) {
        super(innerDistance);
    }

    @Override
    public double calcDistance(Set set1, Set set2) throws ClusException {
        ClusDistance clusDistance = this.m_ChildDistances[0];
        double union = set1.getValues().length + set2.getValues().length;
        double intersection = 0.0;
        for (Object element1 : set1.getValues()) {
            double dist = 1.0;
            for (Object element2 : set2.getValues()) {
                dist = clusDistance == null ? Math.abs((Double)element1 - (Double)element2) : clusDistance.calcDistance(element1, element2);
                if (dist != 0.0) continue;
                intersection += 1.0;
                union -= 1.0;
            }
        }
        return 1.0 - intersection / union;
    }

    @Override
    public String getDistanceName() {
        return "Jaccard distance (sets)";
    }
}

