/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.complex.sets;

import si.ijs.kt.clus.data.type.complex.SetAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.complex.SetDistance;
import si.ijs.kt.clus.ext.structuredTypes.Set;
import si.ijs.kt.clus.util.exception.ClusException;

public class HammingLossDistance
extends SetDistance {
    private static final long serialVersionUID = 1L;
    private int numberOfTotalPossibleValues = 1;

    public HammingLossDistance(SetAttrType attr, ClusDistance innerDistance, int numberOfTotalPossibleValues) {
        super(attr, innerDistance);
        this.numberOfTotalPossibleValues = numberOfTotalPossibleValues;
    }

    public HammingLossDistance(ClusDistance innerDistance, int numberOfTotalPossibleValues) {
        super(innerDistance);
        this.numberOfTotalPossibleValues = numberOfTotalPossibleValues;
    }

    public HammingLossDistance(SetAttrType attr, ClusDistance innerDistance) {
        this(attr, innerDistance, 1);
    }

    @Override
    public double calcDistance(Set set1, Set set2) throws ClusException {
        ClusDistance clusDistance = this.m_ChildDistances[0];
        double distance = set1.getValues().length + set2.getValues().length;
        block0: for (Object element1 : set1.getValues()) {
            double dist = 1.0;
            for (Object element2 : set2.getValues()) {
                dist = clusDistance == null ? Math.abs((Double)element1 - (Double)element2) : clusDistance.calcDistance(element1, element2);
                if (dist != 0.0) continue;
                distance -= 2.0;
                continue block0;
            }
        }
        return distance / (double)this.numberOfTotalPossibleValues;
    }

    @Override
    public String getDistanceName() {
        return "Hamming loss (sets)";
    }
}

