/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.primitive;

import java.io.IOException;
import java.io.PrintWriter;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class TimeSeriesAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;
    public static boolean m_isEqualLength = true;
    int m_Length = -1;

    public TimeSeriesAttrType(String name) {
        super(name, null);
    }

    public TimeSeriesAttrType(String name, String typeDefinition) {
        super(name, typeDefinition);
    }

    @Override
    public ClusAttrType cloneType() {
        TimeSeriesAttrType tsat = new TimeSeriesAttrType(this.m_Name, this.getTypeDefinition());
        return tsat;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.TimeSeries;
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Object;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    public TimeSeries getTimeSeries(DataTuple tuple) {
        return (TimeSeries)tuple.getObjVal(this.m_ArrayIndex);
    }

    public void setTimeSeries(DataTuple tuple, TimeSeries value) {
        tuple.setObjectVal(value, this.m_ArrayIndex);
    }

    @Override
    public String getString(DataTuple tuple) {
        TimeSeries ts_data = (TimeSeries)tuple.getObjVal(0);
        return ts_data.toString();
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    public boolean isEqualLength() {
        return m_isEqualLength;
    }

    @Override
    public void writeARFFType(PrintWriter wrt) throws ClusException {
        wrt.print("TimeSeries");
    }

    @Override
    public boolean isTimeSeries() {
        return true;
    }

    public class MySerializable
    extends ClusSerializable {
        public String getString(DataTuple tuple) {
            TimeSeries ts_data = (TimeSeries)tuple.getObjVal(0);
            double[] data = ts_data.getValues();
            String str = "[";
            for (int k = 0; k < data.length; ++k) {
                str.concat(String.valueOf(data[k]));
                if (k >= data.length - 1) continue;
                str.concat(", ");
            }
            str.concat("]");
            return str;
        }

        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            String str = data.readTimeSeries();
            if (str == null) {
                return false;
            }
            TimeSeries value = new TimeSeries(str);
            tuple.setObjectVal(value, TimeSeriesAttrType.this.getArrayIndex());
            if (TimeSeriesAttrType.this.m_Length != -1) {
                if (TimeSeriesAttrType.this.m_Length != value.length()) {
                    m_isEqualLength = false;
                }
            } else {
                TimeSeriesAttrType.this.m_Length = value.length();
            }
            return true;
        }
    }
}

