/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.primitive;

import java.io.IOException;
import java.io.PrintWriter;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class StringAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;

    public StringAttrType(String name) {
        super(name);
    }

    @Override
    public ClusAttrType cloneType() {
        StringAttrType at = new StringAttrType(this.m_Name);
        this.cloneType(at);
        return at;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.String;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Object;
    }

    @Override
    public String getString(DataTuple tuple) {
        return (String)tuple.getObjVal(this.m_ArrayIndex);
    }

    @Override
    public int compareValue(DataTuple t1, DataTuple t2) {
        String s2;
        String s1 = (String)t1.getObjVal(this.m_ArrayIndex);
        return s1.equals(s2 = (String)t2.getObjVal(this.m_ArrayIndex)) ? 0 : 1;
    }

    @Override
    public void writeARFFType(PrintWriter wrt) throws ClusException {
        wrt.print("string");
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    @Override
    public boolean isString() {
        return true;
    }

    public class MySerializable
    extends ClusSerializable {
        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            String value = data.readString();
            if (value == null) {
                return false;
            }
            tuple.setObjectVal(value, StringAttrType.this.getArrayIndex());
            return true;
        }
    }
}

