/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.primitive;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import si.ijs.kt.clus.algo.kNN.distance.valentin.NominalStatistic;
import si.ijs.kt.clus.data.cols.ColTarget;
import si.ijs.kt.clus.data.cols.attribute.ClusAttribute;
import si.ijs.kt.clus.data.cols.attribute.NominalTarget;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class NominalAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;
    public static final String POSITIVE_CLASS = "1";
    public static final String NEGATIVE_CLASS = "0";
    public static final String[] BINARY_NAMES = new String[]{"1", "0"};
    public static final int POSITIVE_CLASS_INDEX = ArrayUtils.indexOf(BINARY_NAMES, "1");
    private NominalStatistic m_StatNominal;
    private int m_NbValues;
    protected String[] m_Values;
    protected transient Hashtable<String, Integer> m_Hash;

    public NominalAttrType(String name, String type) {
        super(name);
        int len = type.length();
        StringTokenizer tokens = new StringTokenizer(type.substring(1, len - 1), ",");
        ArrayList<String> values = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String value = tokens.nextToken().trim();
            if (value.equals("?")) continue;
            values.add(value);
        }
        Collections.sort(values);
        if (values.size() == 2 && ((String)values.get(0)).equals(NEGATIVE_CLASS) && ((String)values.get(1)).equals(POSITIVE_CLASS)) {
            values.set(0, POSITIVE_CLASS);
            values.set(1, NEGATIVE_CLASS);
        }
        this.m_NbValues = values.size();
        this.m_Values = new String[this.m_NbValues];
        for (int i = 0; i < this.m_NbValues; ++i) {
            this.m_Values[i] = (String)values.get(i);
        }
        this.createHash();
    }

    public void setStatistic(NominalStatistic stat) {
        this.m_StatNominal = stat;
    }

    public NominalStatistic getStatistic() {
        return this.m_StatNominal;
    }

    public String[] getValues() {
        return this.m_Values;
    }

    public NominalAttrType(String name, String[] values) {
        super(name);
        this.m_NbValues = values.length;
        this.m_Values = values;
    }

    public NominalAttrType(String name, ArrayList<String> values) {
        super(name);
        this.m_NbValues = values.size();
        this.m_Values = values.toArray(new String[values.size()]);
    }

    public NominalAttrType(String name) {
        super(name);
        this.m_NbValues = 2;
        this.m_Values = BINARY_NAMES;
    }

    public NominalAttrType(String name, int nbvalues) {
        super(name);
        this.m_NbValues = nbvalues;
        this.m_Values = new String[nbvalues];
    }

    public final void setValue(int idx, String name) {
        this.m_Values[idx] = name;
    }

    @Override
    public ClusAttrType cloneType() {
        NominalAttrType at = new NominalAttrType(this.m_Name, this.m_Values);
        this.cloneType(at);
        return at;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.Nominal;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Int;
    }

    public final int getNbValues() {
        return this.m_NbValues;
    }

    public final int getNbValuesInclMissing() {
        return this.m_NbValues + (this.m_NbMissing > 0 ? 1 : 0);
    }

    public String getValue(int idx) {
        return this.m_Values[idx];
    }

    public String getValueOrMissing(int idx) {
        return idx < this.m_Values.length ? this.m_Values[idx] : "?";
    }

    public Integer getValueIndex(String value) {
        return this.m_Hash.get(value);
    }

    @Override
    public int getMaxNbStats() {
        return this.m_NbValues + 1;
    }

    public void createHash() {
        this.m_Hash = new Hashtable();
        for (int i = 0; i < this.m_NbValues; ++i) {
            this.m_Hash.put(this.m_Values[i], new Integer(i));
        }
    }

    public String getTypeString() {
        StringBuffer res = new StringBuffer();
        res.append("{");
        for (int i = 0; i < this.m_NbValues; ++i) {
            if (i != 0) {
                res.append(",");
            }
            res.append(this.m_Values[i]);
        }
        res.append("}");
        return res.toString();
    }

    @Override
    public String getString(DataTuple tuple) {
        int idx = this.getNominal(tuple);
        return idx >= this.m_NbValues ? "?" : this.m_Values[idx];
    }

    @Override
    public boolean isMissing(DataTuple tuple) {
        return this.getNominal(tuple) >= this.m_NbValues;
    }

    @Override
    public int getNominal(DataTuple tuple) {
        return tuple.getIntVal(this.m_ArrayIndex);
    }

    public void setNominal(DataTuple tuple, int intvalue) {
        tuple.setIntVal(intvalue, this.getArrayIndex());
    }

    @Override
    public int compareValue(DataTuple t1, DataTuple t2) {
        int i2;
        int i1 = this.getNominal(t1);
        return i1 == (i2 = this.getNominal(t2)) ? 0 : 1;
    }

    @Override
    public ClusAttribute createTargetAttr(ColTarget target) {
        return new NominalTarget(target, this, this.getArrayIndex());
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    @Override
    public void writeARFFType(PrintWriter wrt) throws ClusException {
        wrt.print(this.getTypeString());
    }

    @Override
    public void setToMissing(DataTuple tuple) {
        this.setNominal(tuple, this.m_NbValues + 1);
    }

    @Override
    public boolean isNominal() {
        return true;
    }

    public class MySerializable
    extends ClusSerializable {
        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            String value = data.readString();
            if (value == null) {
                return false;
            }
            if (value.equals("?")) {
                NominalAttrType.this.incNbMissing();
                NominalAttrType.this.setNominal(tuple, NominalAttrType.this.getNbValues());
            } else {
                Integer i = NominalAttrType.this.getValueIndex(value);
                if (i != null) {
                    NominalAttrType.this.setNominal(tuple, i);
                } else {
                    throw new IOException("Illegal value '" + value + "' for attribute " + NominalAttrType.this.getName() + " at row " + (data.getRow() + 1));
                }
            }
            return true;
        }
    }
}

