/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.primitive;

import java.io.IOException;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class IntegerAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;

    public IntegerAttrType(String name) {
        super(name);
    }

    @Override
    public ClusAttrType cloneType() {
        IntegerAttrType at = new IntegerAttrType(this.m_Name);
        this.cloneType(at);
        return at;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.Integer;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Int;
    }

    @Override
    public String getString(DataTuple tuple) {
        return String.valueOf(tuple.getIntVal(this.m_ArrayIndex));
    }

    @Override
    public int compareValue(DataTuple t1, DataTuple t2) {
        int s2;
        int s1 = t1.getIntVal(this.m_ArrayIndex);
        return s1 == (s2 = t2.getIntVal(this.m_ArrayIndex)) ? 0 : 1;
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    public class MySerializable
    extends ClusSerializable {
        protected int m_Index;

        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            tuple.setIntVal(this.m_Index++, IntegerAttrType.this.getArrayIndex());
            return true;
        }
    }
}

