/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.primitive;

import java.io.IOException;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class IndexAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;
    protected int m_CrValue;
    protected int[] m_Index;
    protected int m_Max = Integer.MIN_VALUE;
    protected int m_Min = Integer.MAX_VALUE;

    public IndexAttrType(String name) {
        super(name);
    }

    public IndexAttrType(String name, int min, int max) {
        super(name);
        this.m_Max = max;
        this.m_Min = min;
    }

    @Override
    public ClusAttrType cloneType() {
        IndexAttrType at = new IndexAttrType(this.m_Name, this.m_Min, this.m_Max);
        this.cloneType(at);
        return at;
    }

    public int getCrValue() {
        return this.m_CrValue;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.Index;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Double;
    }

    @Override
    public void setNbRows(int nb) {
        this.m_Index = new int[nb];
    }

    public void setValue(int row, int value) {
        this.m_Index[row] = value;
        if (value > this.m_Max) {
            this.m_Max = value;
        }
        if (value < this.m_Min) {
            this.m_Min = value;
        }
    }

    public int getMaxValue() {
        return this.m_Max;
    }

    public int getValue(int row) {
        return this.m_Index[row];
    }

    public int getNbRows() {
        return this.m_Index.length;
    }

    public ClusSerializable createRowSerializable(RowData data, boolean istarget) throws ClusException {
        return new MyReader();
    }

    public class MyReader
    extends ClusSerializable {
        public int getValue(ClusReader data, String value) throws IOException {
            try {
                int ival = Integer.parseInt(value);
                if (ival > IndexAttrType.this.m_Max) {
                    IndexAttrType.this.m_Max = ival;
                }
                if (ival < IndexAttrType.this.m_Min) {
                    IndexAttrType.this.m_Min = ival;
                }
                return ival;
            }
            catch (NumberFormatException e) {
                throw new IOException("Illegal value '" + value + "' for attribute " + IndexAttrType.this.getName() + " at row " + (data.getRow() + 1));
            }
        }

        public boolean read(ClusReader data, int row) throws IOException {
            String value = data.readString();
            if (value == null) {
                return false;
            }
            IndexAttrType.this.m_Index[row] = this.getValue(data, value);
            return true;
        }

        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            String value = data.readString();
            if (value == null) {
                return false;
            }
            IndexAttrType.this.m_CrValue = this.getValue(data, value);
            return true;
        }
    }
}

