/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.hierarchies;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.StringAttrType;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchyPreproc;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.ext.hierarchical.ClassesValue;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsHMLC;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;
import si.ijs.kt.clus.util.jeans.util.array.StringTable;

public class ClassesAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;
    protected transient String[] m_Labels;
    protected transient StringTable m_Table = new StringTable();
    protected ClassHierarchy m_Hier;

    public ClassesAttrType(String name) {
        super(name);
        this.m_Hier = new ClassHierarchy(this);
    }

    public ClassesAttrType(String name, ClassHierarchy hier) {
        super(name);
        this.m_Hier = hier;
    }

    public ClassesAttrType(String name, String atype) {
        super(name);
        String classes = atype.substring("HIERARCHICAL".length()).trim();
        this.m_Labels = classes.split("\\s*\\,\\s*");
        this.m_Hier = new ClassHierarchy(this);
    }

    public StringTable getTable() {
        return this.m_Table;
    }

    public ClassHierarchy getHier() {
        return this.m_Hier;
    }

    @Override
    public boolean isMissing(DataTuple tuple) {
        return this.getValue(tuple).getNbClasses() == 0;
    }

    @Override
    public ClusAttrType cloneType() {
        ClassesAttrType at = new ClassesAttrType(this.m_Name, this.m_Hier);
        this.cloneType(at);
        return at;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.Classes;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Object;
    }

    public ClassesTuple getValue(DataTuple t1) {
        return (ClassesTuple)t1.getObjVal(this.getArrayIndex());
    }

    public void setValue(DataTuple t1, ClassesTuple val) {
        t1.setObjectVal(val, this.getArrayIndex());
    }

    @Override
    public void setToMissing(DataTuple t) {
        try {
            this.setValue(t, new ClassesTuple(ClassesValue.EMPTY_SET_INDICATOR, null));
        }
        catch (ClusException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updatePredictWriterSchema(ClusSchema schema) {
        String name = this.getName();
        schema.addAttrType(new StringAttrType(name + "-a"));
        ClassHierarchy hier = this.getHier();
        String[] vals = new String[]{"1", "0"};
        for (int i = 0; i < hier.getTotal(); ++i) {
            ClassTerm term = hier.getTermAt(i);
            schema.addAttrType(new NominalAttrType(name + "-a-" + term.toStringHuman(hier), vals));
        }
    }

    @Override
    public String getPredictionWriterString(DataTuple tuple) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getString(tuple));
        buf.append(",");
        buf.append(this.getVectorString(tuple));
        return buf.toString();
    }

    @Override
    public String getString(DataTuple tuple) {
        ClassesTuple ct = (ClassesTuple)tuple.getObjVal(this.m_ArrayIndex);
        return ct.toStringData(this.m_Hier);
    }

    public String getVectorString(DataTuple tuple) {
        ClassesTuple ct = (ClassesTuple)tuple.getObjVal(this.m_ArrayIndex);
        boolean[] vec = ct.getVectorBooleanNodeAndAncestors(this.m_Hier);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vec.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(vec[i] ? "1" : "0");
        }
        return buf.toString();
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    @Override
    public void getPreprocs(DataPreprocs pps, boolean single) {
        pps.addPreproc(new ClassHierarchyPreproc(this, true));
    }

    @Override
    public void initializeBeforeLoadingData() throws IOException, ClusException {
        SettingsHMLC.HierarchyType t;
        if (this.isDisabled()) {
            return;
        }
        SettingsHMLC sett = this.getSettings().getHMLC();
        if (sett.hasDefinitionFile()) {
            this.m_Hier.loadDAG(sett.getDefinitionFile());
            this.m_Hier.initialize();
        }
        if ((t = sett.getHierType()).equals((Object)SettingsHMLC.HierarchyType.Unknown)) {
            t = ClassesAttrType.guessHierarhcyType(this.m_Labels);
            this.m_Hier.setHierTypeFromSettings(t);
        }
        if (this.m_Labels != null) {
            if (t.equals((Object)SettingsHMLC.HierarchyType.DAG)) {
                this.m_Hier.loadDAG(this.m_Labels);
            } else if (t.equals((Object)SettingsHMLC.HierarchyType.Tree)) {
                for (int i = 0; i < this.m_Labels.length; ++i) {
                    if (this.m_Labels[i].equals(ClassesValue.EMPTY_SET_INDICATOR)) continue;
                    ClassesValue val = new ClassesValue(this.m_Labels[i], this.m_Table);
                    this.m_Hier.addClass(val);
                }
            } else {
                throw new RuntimeException("Wrong hierarchy type");
            }
            this.m_Hier.initialize();
        }
    }

    private static SettingsHMLC.HierarchyType guessHierarhcyType(String[] labels) {
        for (String label : labels) {
            if (StringUtils.countMatches(label, ClassesValue.HIERARCY_SEPARATOR) <= 1) continue;
            return SettingsHMLC.HierarchyType.Tree;
        }
        return SettingsHMLC.HierarchyType.DAG;
    }

    @Override
    public void initializeFrom(ClusAttrType other_type) {
        ClassesAttrType other = (ClassesAttrType)other_type;
        this.m_Hier = other.getHier();
    }

    public void initSettings(Settings sett) {
        SettingsHMLC.HierarchyType t = sett.getHMLC().getHierType();
        this.getHier().setHierTypeFromSettings(t);
    }

    @Override
    public void writeARFFType(PrintWriter wrt) throws ClusException {
        ArrayList<String> list = null;
        list = this.getSettings().getHMLC().getHierType().equals((Object)SettingsHMLC.HierarchyType.DAG) ? this.getHier().getAllParentChildTuples() : this.getHier().getAllPaths();
        wrt.print("hierarchical ");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                wrt.print(",");
            }
            wrt.print(list.get(i));
        }
    }

    @Override
    public boolean isClasses() {
        return true;
    }

    public class MySerializable
    extends ClusSerializable {
        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            String val = data.readString();
            if (val == null) {
                return false;
            }
            try {
                ClassesTuple ct = new ClassesTuple(val, ClassesAttrType.this.m_Table);
                ct.setAllIntermediate(false);
                tuple.setObjectVal(ct, ClassesAttrType.this.getArrayIndex());
            }
            catch (ClusException e) {
                throw new IOException("Error parsing attribute " + ClassesAttrType.this.getName() + " '" + val + "' at row: " + (data.getRow() + 1));
            }
            return true;
        }
    }
}

