/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;

public class BitwiseNominalAttrType
extends NominalAttrType {
    public static final long serialVersionUID = 1L;
    protected int m_Bits;
    protected int m_BitMask;
    protected int m_BitPosition;
    public static final double LOG2 = Math.log(2.0);

    public BitwiseNominalAttrType(String name, String type) {
        super(name, type);
        this.initBitwiseNominal();
    }

    public BitwiseNominalAttrType(String name, String[] values) {
        super(name, values);
        this.initBitwiseNominal();
    }

    public BitwiseNominalAttrType(String name) {
        super(name);
        this.initBitwiseNominal();
    }

    public BitwiseNominalAttrType(String name, int nbvalues) {
        super(name, nbvalues);
        this.initBitwiseNominal();
    }

    public void initBitwiseNominal() {
        this.m_Bits = Math.round((float)(Math.log(this.getNbValues() + 1) / LOG2 + 0.5));
        this.m_BitMask = (1 << this.m_Bits) - 1;
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.BitwiseInt;
    }

    @Override
    public int getNominal(DataTuple tuple) {
        return tuple.getIntVal(this.m_ArrayIndex) >> this.m_BitPosition & this.m_BitMask;
    }

    @Override
    public void setNominal(DataTuple tuple, int value) {
        int intvalue = tuple.getIntVal(this.getArrayIndex()) | value << this.getBitPosition();
        tuple.setIntVal(intvalue, this.getArrayIndex());
    }

    public int getNbBits() {
        return this.m_Bits;
    }

    public void setBitPosition(int bp) {
        this.m_BitPosition = bp;
    }

    public int getBitPosition() {
        return this.m_BitPosition;
    }

    @Override
    public ClusAttrType cloneType() {
        BitwiseNominalAttrType at = new BitwiseNominalAttrType(this.m_Name, this.m_Values);
        this.cloneType(at);
        return at;
    }

    @Override
    public void copyArrayIndex(ClusAttrType type) {
        this.m_Index = type.m_Index;
        this.m_ArrayIndex = type.m_ArrayIndex;
        this.m_Status = type.m_Status;
        this.m_BitPosition = ((BitwiseNominalAttrType)type).m_BitPosition;
    }
}

