/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.rows;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class TupleIterator {
    protected DataPreprocs m_Procs;
    protected boolean m_ShouldAttach;

    public TupleIterator() {
        this.m_Procs = new DataPreprocs();
    }

    public TupleIterator(DataPreprocs procs) {
        this.m_Procs = procs != null ? procs : new DataPreprocs();
    }

    public abstract DataTuple readTuple() throws IOException, ClusException;

    public abstract ClusSchema getSchema();

    public void init() throws IOException, ClusException {
    }

    public void close() throws IOException {
    }

    public final void preprocTuple(DataTuple tuple) throws ClusException {
        if (tuple != null) {
            this.m_Procs.preprocSingle(tuple);
        }
    }

    public final void setPreprocs(DataPreprocs procs) {
        this.m_Procs = procs;
    }

    public final boolean shouldAttach() {
        return this.m_ShouldAttach;
    }

    public final void setShouldAttach(boolean attach) {
        this.m_ShouldAttach = attach;
    }

    public ClusData getData() {
        return null;
    }

    public ClusData createInMemoryData() throws IOException, ClusException {
        this.init();
        ArrayList<DataTuple> list = new ArrayList<DataTuple>();
        DataTuple tuple = this.readTuple();
        while (tuple != null) {
            list.add(tuple);
            tuple = this.readTuple();
        }
        return new RowData(list, this.getSchema());
    }
}

