/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Scanner;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRHierarchy;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class ClusView {
    protected ArrayList<ClusSerializable> m_Attr = new ArrayList();

    public int getNbAttributes() {
        return this.m_Attr.size();
    }

    public ClusSerializable getAttribute(int idx) {
        return this.m_Attr.get(idx);
    }

    public void addAttribute(ClusSerializable attr) {
        this.m_Attr.add(attr);
    }

    public RowData readData(ClusReader reader, ClusSchema schema, boolean isTest) throws IOException, ClusException {
        schema.setReader(true);
        ArrayList<DataTuple> items = new ArrayList<DataTuple>();
        DataTuple tuple = this.readDataTupleFirst(reader, schema);
        while (tuple != null) {
            items.add(tuple);
            tuple = this.readDataTupleNext(reader, schema);
        }
        for (int j = 0; j < this.m_Attr.size(); ++j) {
            ClusSerializable attr = this.m_Attr.get(j);
            attr.term(schema);
        }
        schema.setReader(false);
        return new RowData(items, schema, isTest);
    }

    public RowData readData(ClusReader reader, ClusSchema schema) throws IOException, ClusException {
        return this.readData(reader, schema, false);
    }

    public DataTuple readDataTupleFirst(ClusReader reader, ClusSchema schema) throws IOException, ClusException {
        if (!reader.hasMoreTokens()) {
            return null;
        }
        boolean sparse = reader.isNextChar(123);
        if (sparse) {
            this.m_Attr.clear();
            schema.ensureSparse();
            schema.createNormalView(this);
        }
        return this.readDataTuple(reader, schema, sparse);
    }

    public DataTuple readDataTupleNext(ClusReader reader, ClusSchema schema) throws IOException {
        if (!reader.hasMoreTokens()) {
            return null;
        }
        boolean sparse = reader.isNextChar(123);
        if (sparse && !schema.isSparse()) {
            throw new IOException("Sparse tuple found in a non-sparse data set (at row " + (reader.getRow() + 1) + ")");
        }
        return this.readDataTuple(reader, schema, sparse);
    }

    public DataTuple readDataTuple(ClusReader reader, ClusSchema schema) throws IOException {
        if (!reader.hasMoreTokens()) {
            return null;
        }
        boolean sparse = reader.isNextChar(123);
        return this.readDataTuple(reader, schema, sparse);
    }

    public DataTuple readDataTuple(ClusReader reader, ClusSchema schema, boolean sparse) throws IOException {
        DataTuple tuple = schema.createTuple();
        if (sparse) {
            while (!reader.isNextChar(125)) {
                int idx = reader.readIntIndex();
                if (idx < 1 || idx > this.m_Attr.size()) {
                    throw new IOException("Error attribute index '" + idx + "' out of range [1," + this.m_Attr.size() + "] at row " + (reader.getRow() + 1));
                }
                ClusSerializable attr = this.m_Attr.get(idx - 1);
                if (attr.read(reader, tuple)) continue;
                throw new IOException("Error reading attribute " + this.m_Attr + " at row " + (reader.getRow() + 1));
            }
        } else if (this.m_Attr.size() > 0) {
            ClusSerializable attr_0 = this.m_Attr.get(0);
            if (!attr_0.read(reader, tuple)) {
                return null;
            }
            for (int j = 1; j < this.m_Attr.size(); ++j) {
                ClusSerializable attr = this.m_Attr.get(j);
                if (attr.read(reader, tuple)) continue;
                throw new IOException("Error reading attribute with index " + j + " (" + this.m_Attr.get(j) + "), at row " + (reader.getRow() + 1));
            }
        }
        if (reader.isNextCharNoSpace(123)) {
            if (!reader.readNoSpace()) {
                throw new IOException("Error reading tuple weight at row " + (reader.getRow() + 1));
            }
            tuple.setWeight(reader.getFloat());
            if (!reader.isNextChar(125)) {
                throw new IOException("Expected closing '}' after tuple weight at row " + (reader.getRow() + 1));
            }
        }
        reader.readEol();
        return tuple;
    }

    public RowData readDataHMTR(ClusReader reader, ClusSchema schema, ClusHMTRHierarchy hmtrHierarchy, Settings settings) throws IOException, ClusException {
        schema.setReader(true);
        ArrayList<DataTuple> items = new ArrayList<DataTuple>();
        FileWriter fr = null;
        BufferedWriter br = null;
        File file = Paths.get(settings.getData().getDataFile() + ".hmtr", new String[0]).toFile();
        String newLine = System.lineSeparator();
        boolean incorrectDump = true;
        String agg = "";
        String hier = "";
        String line = "";
        if (file.exists()) {
            try (FileInputStream inputStream = new FileInputStream(file);
                 Scanner sc = new Scanner((InputStream)inputStream, "UTF-8");){
                if (sc.hasNextLine()) {
                    agg = sc.nextLine();
                }
                if (sc.hasNextLine()) {
                    hier = sc.nextLine();
                }
                if (sc.hasNextLine()) {
                    sc.nextLine();
                }
                String aggFromS = settings.getHMTR().getHMTRAggregationName();
                String hierFromS = settings.getHMTR().getHMTRHierarchyString();
                if (agg.equals(aggFromS) && hier.equals(hierFromS)) {
                    incorrectDump = false;
                    schema.getSettings().getHMTR().setHMTRUsingDump(true);
                    if (!sc.hasNextLine()) {
                        throw new IOException("Dump has different number of rows! Try deleting the dump file: " + file.getAbsolutePath());
                    }
                    line = sc.nextLine();
                    if (line.equals("") || line.equals(" ") || line.equals("\t")) {
                        if (sc.hasNextLine()) {
                            line = sc.nextLine();
                        } else {
                            throw new IOException("Dump has different number of rows! Try deleting the dump file: " + file.getAbsolutePath());
                        }
                    }
                    DataTuple tuple = this.readDataHMTRTupleFirst(reader, schema, hmtrHierarchy, line);
                    while (tuple != null) {
                        items.add(tuple);
                        if (sc.hasNextLine()) {
                            line = sc.nextLine();
                        }
                        if (line.equals("") || line.equals(" ") || line.equals("\t")) {
                            if (sc.hasNextLine()) {
                                line = sc.nextLine();
                            } else {
                                throw new IOException("Dump has different number of rows! Try deleting the dump file: " + file.getAbsolutePath());
                            }
                        }
                        tuple = this.readDataHMTRTupleNext(reader, schema, hmtrHierarchy, line);
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        if (incorrectDump) {
            fr = new FileWriter(file);
            br = new BufferedWriter(fr);
            br.write(settings.getHMTR().getHMTRAggregationName() + newLine + settings.getHMTR().getHMTRHierarchyString() + newLine + newLine);
            DataTuple tuple = this.readDataHMTRTupleFirst(reader, schema, hmtrHierarchy, line);
            while (tuple != null) {
                String[] toWrites = tuple.toString().split(",");
                String toWrite = "";
                for (int i = toWrites.length - schema.getNbHMTRAttributes(); i < toWrites.length; ++i) {
                    toWrite = toWrite + "," + toWrites[i];
                }
                toWrite = toWrite.substring(1);
                items.add(tuple);
                br.write(toWrite + newLine);
                tuple = this.readDataHMTRTupleNext(reader, schema, hmtrHierarchy, line);
            }
        }
        if (br != null) {
            br.close();
        }
        if (fr != null) {
            fr.close();
        }
        for (int j = 0; j < this.m_Attr.size(); ++j) {
            ClusSerializable attr = this.m_Attr.get(j);
            attr.term(schema);
        }
        schema.setReader(false);
        return new RowData(items, schema);
    }

    public DataTuple readDataHMTRTupleFirst(ClusReader reader, ClusSchema schema, ClusHMTRHierarchy hmtrHierarchy, String line) throws IOException, ClusException {
        if (!reader.hasMoreTokens()) {
            return null;
        }
        boolean sparse = reader.isNextChar(123);
        if (sparse) {
            this.m_Attr.clear();
            schema.ensureSparse();
            schema.createNormalView(this);
        }
        return this.readDataHMTRTuple(reader, schema, sparse, hmtrHierarchy, line);
    }

    public DataTuple readDataHMTRTupleNext(ClusReader reader, ClusSchema schema, ClusHMTRHierarchy hmtrHierarchy, String line) throws IOException {
        if (!reader.hasMoreTokens()) {
            return null;
        }
        boolean sparse = reader.isNextChar(123);
        if (sparse && !schema.isSparse()) {
            throw new IOException("Sparse tuple found in a non-sparse data set (at row " + (reader.getRow() + 1) + ")");
        }
        return this.readDataHMTRTuple(reader, schema, sparse, hmtrHierarchy, line);
    }

    public DataTuple readDataHMTRTuple(ClusReader reader, ClusSchema schema, ClusHMTRHierarchy hmtrHierarchy, String line) throws IOException {
        if (!reader.hasMoreTokens()) {
            return null;
        }
        boolean sparse = reader.isNextChar(123);
        return this.readDataHMTRTuple(reader, schema, sparse, hmtrHierarchy, line);
    }

    public DataTuple readDataHMTRTuple(ClusReader reader, ClusSchema schema, boolean sparse, ClusHMTRHierarchy hmtrHierarchy, String line) throws IOException {
        DataTuple tuple = schema.createTuple();
        if (sparse) {
            while (!reader.isNextChar(125)) {
                int idx = reader.readIntIndex();
                if (idx < 1 || idx > this.m_Attr.size()) {
                    throw new IOException("Error attribute index '" + idx + "' out of range [1," + this.m_Attr.size() + "] at row " + (reader.getRow() + 1));
                }
                ClusSerializable attr = this.m_Attr.get(idx - 1);
                if (attr.read(reader, tuple)) continue;
                throw new IOException("Error reading attirbute " + this.m_Attr + " at row " + (reader.getRow() + 1));
            }
        } else if (this.m_Attr.size() > 0) {
            ClusSerializable attr;
            int j;
            ClusSerializable attr_0 = this.m_Attr.get(0);
            if (!attr_0.read(reader, tuple)) {
                return null;
            }
            for (j = 1; j < this.m_Attr.size() - schema.getNbHMTRAttributes(); ++j) {
                attr = this.m_Attr.get(j);
                if (attr.read(reader, tuple)) continue;
                throw new IOException("Error reading attirbute " + this.m_Attr + " at row " + (reader.getRow() + 1));
            }
            if (schema.getSettings().getHMTR().isHMTRUsingDump()) {
                for (j = this.m_Attr.size() - schema.getNbHMTRAttributes(); j < this.m_Attr.size(); ++j) {
                    attr = this.m_Attr.get(j);
                    if (attr.readHMTRAttribute(reader, tuple, schema, hmtrHierarchy, line)) continue;
                    throw new IOException("Error calculating Hierarchical MTR attribute " + this.m_Attr + " at row " + (reader.getRow() + 1));
                }
            } else {
                for (j = this.m_Attr.size() - schema.getNbHMTRAttributes(); j < this.m_Attr.size(); ++j) {
                    attr = this.m_Attr.get(j);
                    if (attr.calculateHMTRAttribute(reader, tuple, schema, hmtrHierarchy)) continue;
                    throw new IOException("Error calculating Hierarchical MTR attribute " + this.m_Attr + " at row " + (reader.getRow() + 1));
                }
            }
        }
        if (reader.isNextCharNoSpace(123)) {
            if (!reader.readNoSpace()) {
                throw new IOException("Error reading tuple weight at row " + (reader.getRow() + 1));
            }
            tuple.setWeight(reader.getFloat());
            if (!reader.isNextChar(125)) {
                throw new IOException("Expected closing '}' after tuple weight at row " + (reader.getRow() + 1));
            }
        }
        reader.readEol();
        return tuple;
    }
}

