/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.zip.ZipInputStream;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.jeans.util.FileUtil;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class ClusReader {
    String m_Name;
    int m_Row = 0;
    int m_Attr = 0;
    int m_LastChar = 0;
    MStreamTokenizer m_Token;
    StringBuffer m_Scratch = new StringBuffer();
    Settings m_Settings;
    boolean m_IsClosed;
    public static final int CHAR_NL = 10;
    public static final int CHAR_CR = 13;

    public ClusReader(String fname, Settings sett) throws IOException {
        this.m_Name = fname;
        this.m_Settings = sett;
        this.m_IsClosed = true;
        this.open();
    }

    public String getName() {
        return this.m_Name;
    }

    public int getRow() {
        return this.m_Row;
    }

    public int countRows() throws IOException {
        int nbr = this.countRows2();
        this.reOpen();
        return nbr;
    }

    public MStreamTokenizer zipOpen(String fname) throws IOException {
        ZipInputStream zip = new ZipInputStream(new FileInputStream(fname));
        zip.getNextEntry();
        return new MStreamTokenizer(zip);
    }

    public void open() throws IOException {
        String fname = this.m_Name;
        if (this.m_Settings != null) {
            this.m_Settings.getGeneric().getFileAbsolute(this.m_Name);
        }
        if (FileUtil.fileExists(fname)) {
            this.m_Token = fname.toUpperCase().endsWith(".ZIP") ? this.zipOpen(fname) : new MStreamTokenizer(fname);
        } else {
            String zipname = fname + ".zip";
            if (FileUtil.fileExists(zipname)) {
                this.m_Token = this.zipOpen(zipname);
            } else {
                throw new FileNotFoundException("'" + fname + "'");
            }
        }
        this.m_Token.setCommentChar(37);
        this.m_IsClosed = false;
    }

    public boolean isClosed() {
        return this.m_IsClosed;
    }

    public void tryReOpen() throws IOException {
        if (this.isClosed()) {
            this.reOpen();
        }
    }

    public void reOpen() throws IOException {
        this.close();
        this.open();
    }

    public void close() throws IOException {
        this.m_Token.close();
        this.m_IsClosed = true;
    }

    public MStreamTokenizer getTokens() {
        return this.m_Token;
    }

    public boolean isNextToken(String token) throws IOException {
        return this.m_Token.isNextToken(token);
    }

    public boolean hasMoreTokens() throws IOException {
        Reader reader = this.m_Token.getReader();
        int ch = reader.read();
        this.setLastChar(ch);
        return ch != -1;
    }

    public boolean isEol() throws IOException {
        Reader reader = this.m_Token.getReader();
        int ch = this.getNextChar(reader);
        if (ch == 10 || ch == 13) {
            return true;
        }
        this.setLastChar(ch);
        return false;
    }

    public void setLastChar(int ch) {
        this.m_LastChar = ch;
    }

    public int getNextChar(Reader reader) throws IOException {
        if (this.m_LastChar != 0) {
            int ch = this.m_LastChar;
            this.m_LastChar = 0;
            return ch;
        }
        return reader.read();
    }

    public int getNextChar() throws IOException {
        return this.getNextChar(this.m_Token.getReader());
    }

    public int getNextCharNoSpace() throws IOException {
        int ch = this.getNextChar();
        while (ch == 32 || ch == 9) {
            ch = this.getNextChar();
        }
        return ch;
    }

    public boolean isNextChar(int ch) throws IOException {
        int found = this.getNextChar();
        if (ch == found) {
            return true;
        }
        this.setLastChar(found);
        return false;
    }

    public boolean isNextCharNoSpace(int ch) throws IOException {
        int found = this.getNextCharNoSpace();
        if (ch == found) {
            return true;
        }
        this.setLastChar(found);
        return false;
    }

    public void ensureNextChar(int ch) throws IOException {
        int found = this.getNextChar();
        if (ch != found) {
            throw new IOException("Character '" + (char)ch + "' expected on row " + this.m_Row + ", not '" + (char)found + "'");
        }
    }

    public void readEol() throws IOException {
        boolean allowall = false;
        Reader reader = this.m_Token.getReader();
        int ch = this.getNextChar(reader);
        while (ch != -1) {
            if (ch == 10) {
                this.m_Attr = 0;
                ++this.m_Row;
                break;
            }
            if (ch == 37) {
                allowall = true;
            } else if (ch != 32 && ch != 9 && !allowall && ch != 13) {
                StringBuffer err = new StringBuffer();
                for (int cnt = 0; ch != 10 && ch != 13 && cnt < 100; ++cnt) {
                    err.append((char)ch);
                    ch = this.getNextChar(reader);
                }
                throw new IOException("Too many data on row " + this.m_Row + ": '" + err.toString() + "'");
            }
            ch = reader.read();
        }
    }

    public void readTillEol() throws IOException {
        Reader reader = this.m_Token.getReader();
        int ch = this.getNextChar(reader);
        while (ch != -1) {
            if (ch == 10 || ch == 13) {
                this.setLastChar(ch);
                break;
            }
            ch = reader.read();
        }
    }

    public String readString() throws IOException {
        String result;
        int nb = 0;
        Reader reader = this.m_Token.getReader();
        this.m_Scratch.setLength(0);
        int ch = this.getNextChar(reader);
        while (ch != -1 && ch != 44 && ch != 125) {
            if (ch == 37) {
                this.readTillEol();
                break;
            }
            if (ch != 9 && ch != 10 && ch != 13) {
                this.m_Scratch.append((char)ch);
                if (ch != 32) {
                    ++nb;
                }
                if (nb == 1 && ch == 34) {
                    ch = reader.read();
                    while (ch != -1 && ch != 10 && ch != 13 && ch != 34) {
                        this.m_Scratch.append((char)ch);
                        ch = reader.read();
                    }
                    if (ch == 34) {
                        this.m_Scratch.append((char)ch);
                    }
                }
            } else {
                if (ch == 10 || ch == 13) {
                    this.setLastChar(ch);
                }
                if (nb > 0) break;
            }
            ch = reader.read();
        }
        if (ch == 125) {
            this.setLastChar(ch);
        }
        if ((result = this.m_Scratch.toString().trim()).length() > 0) {
            ++this.m_Attr;
            return result;
        }
        return null;
    }

    public String readName() throws IOException {
        this.readNoSpace();
        if (this.m_Scratch.length() > 0) {
            String value = this.m_Scratch.toString();
            return value;
        }
        throw new IOException("Error reading name at row " + (this.m_Row + 1));
    }

    public boolean readNoSpace() throws IOException {
        int nb = 0;
        Reader reader = this.m_Token.getReader();
        this.m_Scratch.setLength(0);
        int ch = this.getNextChar(reader);
        while (ch != -1 && ch != 44 && ch != 125) {
            if (ch != 32 && ch != 9 && ch != 10 && ch != 13) {
                if (ch != 39 && ch != 34) {
                    this.m_Scratch.append((char)ch);
                    ++nb;
                }
            } else {
                if (ch == 10 || ch == 13) {
                    this.setLastChar(ch);
                }
                if (nb > 0) break;
            }
            ch = reader.read();
        }
        if (ch == 125) {
            this.setLastChar(ch);
        }
        return this.m_Scratch.length() > 0;
    }

    public double getFloat() throws IOException {
        if (this.m_Scratch.length() > 0) {
            ++this.m_Attr;
            String value = this.m_Scratch.toString();
            try {
                if (value.equals("?")) {
                    return Double.POSITIVE_INFINITY;
                }
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IOException("Error parsing numeric value '" + value + "' for attribute " + this.m_Attr + " at row " + (this.m_Row + 1));
            }
        }
        throw new IOException("Error reading numeric attirbute " + this.m_Attr + " at row " + (this.m_Row + 1));
    }

    public double readFloat() throws IOException {
        this.readNoSpace();
        return this.getFloat();
    }

    public int readIntIndex() throws IOException {
        this.readNoSpace();
        if (this.m_Scratch.length() > 0) {
            String value = this.m_Scratch.toString();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IOException("Error parsing integer index '" + value + "' at row " + (this.m_Row + 1));
            }
        }
        throw new IOException("Error: empty index at row " + (this.m_Row + 1));
    }

    public String readTimeSeries() throws IOException {
        String result;
        Reader reader = this.m_Token.getReader();
        this.m_Scratch.setLength(0);
        int ch = this.getNextChar(reader);
        while ((ch == 32 || ch == 9 || ch == 10 || ch == 13) && ch != -1) {
            ch = this.getNextChar(reader);
        }
        if (ch != 91) {
            throw new IOException("Error parsing time series attribute " + this.m_Attr + " at row " + (this.m_Row + 1) + ": '[' not found");
        }
        this.m_Scratch.append((char)ch);
        ch = this.getNextChar(reader);
        while (ch != -1) {
            if (ch != 9) {
                this.m_Scratch.append((char)ch);
            }
            if (ch == 93) {
                ch = this.getNextChar(reader);
                if (ch != 10 && ch != 13) break;
                this.setLastChar(ch);
                break;
            }
            ch = this.getNextChar(reader);
        }
        if ((result = this.m_Scratch.toString().trim()).length() > 0) {
            ++this.m_Attr;
            return result;
        }
        return null;
    }

    public String readSet() throws IOException {
        String result;
        Reader reader = this.m_Token.getReader();
        this.m_Scratch.setLength(0);
        int open = 0;
        int ch = this.getNextChar(reader);
        while ((ch == 32 || ch == 9 || ch == 10 || ch == 13) && ch != -1) {
            ch = this.getNextChar(reader);
        }
        if (ch != 123) {
            throw new IOException("Error parsing set attribute " + this.m_Attr + " at row " + (this.m_Row + 1) + ": '{' not found");
        }
        ++open;
        this.m_Scratch.append((char)ch);
        ch = this.getNextChar(reader);
        while (ch != -1) {
            if (ch != 9) {
                this.m_Scratch.append((char)ch);
            }
            if (ch == 123) {
                ++open;
            }
            if (ch == 125) {
                --open;
            }
            if (ch == 125 && open == 0) {
                ch = this.getNextChar(reader);
                if (ch != 10 && ch != 13) break;
                this.setLastChar(13);
                break;
            }
            ch = this.getNextChar(reader);
        }
        if ((result = this.m_Scratch.toString().trim()).length() > 0) {
            ++this.m_Attr;
            return result;
        }
        return null;
    }

    public String readTuple() throws IOException {
        String result;
        Reader reader = this.m_Token.getReader();
        this.m_Scratch.setLength(0);
        int open = 0;
        int ch = this.getNextChar(reader);
        while ((ch == 32 || ch == 9 || ch == 10 || ch == 13) && ch != -1) {
            ch = this.getNextChar(reader);
        }
        if (ch != 91) {
            throw new IOException("Error parsing tuple attribute " + this.m_Attr + " at row " + (this.m_Row + 1) + ": '[' not found");
        }
        ++open;
        this.m_Scratch.append((char)ch);
        ch = this.getNextChar(reader);
        while (ch != -1) {
            if (ch != 9) {
                this.m_Scratch.append((char)ch);
            }
            if (ch == 91) {
                ++open;
            }
            if (ch == 93) {
                --open;
            }
            if (ch == 93 && open == 0) {
                ch = this.getNextChar(reader);
                if (ch != 10 && ch != 13) break;
                this.setLastChar(13);
                break;
            }
            ch = this.getNextChar(reader);
        }
        if ((result = this.m_Scratch.toString().trim()).length() > 0) {
            ++this.m_Attr;
            return result;
        }
        return null;
    }

    public boolean skipTillComma() throws IOException {
        return this.skipTillCommaValentinModified();
    }

    public boolean skipTillCommaOriginal() throws IOException {
        int nb = 0;
        boolean is_ts = false;
        Reader reader = this.m_Token.getReader();
        int ch = this.getNextChar(reader);
        while (ch != -1 && ch != 44 && ch != 125) {
            if (ch != 32 && ch != 9 && ch != 10 && ch != 13) {
                if (ch == 91) {
                    is_ts = true;
                    break;
                }
                ++nb;
            } else {
                if (ch == 10 || ch == 13) {
                    this.setLastChar(13);
                }
                if (nb > 0) break;
            }
            ch = reader.read();
        }
        int prev = ch;
        while (ch != -1 && prev != 93 && is_ts) {
            if (ch != 32 && ch != 9 && ch != 10 && ch != 13) {
                ++nb;
            } else {
                if (ch == 10 || ch == 13) {
                    this.setLastChar(13);
                }
                if (nb > 0) break;
            }
            prev = ch;
            ch = reader.read();
        }
        if (ch == 125) {
            this.m_LastChar = ch;
        }
        return ch != -1;
    }

    public boolean skipTillCommaValentinModified() throws IOException {
        Reader reader = this.m_Token.getReader();
        int ch = this.getNextChar(reader);
        int open = 0;
        int nb = 0;
        while (ch != -1) {
            if (open == 0) {
                if (ch == 44) break;
                if (ch == 10 || ch == 13) {
                    this.setLastChar(ch);
                    if (nb > 0) break;
                }
            }
            if (ch == 91 || ch == 123) {
                ++open;
            }
            if (ch == 93 || ch == 125) {
                --open;
            }
            ++nb;
            ch = reader.read();
        }
        if (ch == 125) {
            this.m_LastChar = ch;
        }
        return ch != -1;
    }

    public int countRows2() throws IOException {
        int nbrows = 0;
        int nbchars = 0;
        Reader reader = this.m_Token.getReader();
        int ch = reader.read();
        while (ch != -1) {
            if (ch == 10 || ch == 13) {
                if (nbchars > 0) {
                    ++nbrows;
                }
                nbchars = 0;
            } else if (ch != 32 && ch != 9) {
                ++nbchars;
            }
            ch = reader.read();
        }
        return nbrows;
    }

    public boolean ensureAtEnd() throws IOException {
        Reader reader = this.m_Token.getReader();
        int ch = reader.read();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            ch = reader.read();
        }
        return ch == -1;
    }
}

