/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.io.ClusView;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.BitwiseNominalAttrType;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.complex.SetAttrType;
import si.ijs.kt.clus.data.type.complex.TupleAttrType;
import si.ijs.kt.clus.data.type.hierarchies.ClassesAttrType;
import si.ijs.kt.clus.data.type.hierarchies.ClassesAttrTypeSingleLabel;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.data.type.primitive.StringAttrType;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ARFFFile {
    protected static final String TAG_ERROR = " tag not found in ARFF file, found instead: '";
    protected static final String[] TAG_NAME = new String[]{"@RELATION", "@ATTRIBUTE", "@DATA"};
    protected ClusReader m_Reader;
    protected int m_DataLine = -1;

    public ARFFFile(ClusReader reader) {
        this.m_Reader = reader;
    }

    public ClusSchema read(Settings sett) throws IOException, ClusException {
        int expected = 0;
        ClusSchema schema = new ClusSchema(this.m_Reader.getName());
        schema.setSettings(sett);
        MStreamTokenizer tokens = this.m_Reader.getTokens();
        String token = tokens.getToken().toUpperCase();
        HashMap<String, int[]> attrMap = new HashMap<String, int[]>();
        while (expected < 3) {
            if (token == null) {
                throw new IOException("End of ARFF file before " + TAG_NAME[expected] + " tag");
            }
            if (token.equals(TAG_NAME[0])) {
                schema.setRelationName(tokens.readTillEol().trim());
                expected = 1;
            } else if (token.equals(TAG_NAME[1])) {
                if (expected == 0) {
                    throw new IOException(TAG_NAME[expected] + TAG_ERROR + token + "'");
                }
                String aname = tokens.getDelimToken('\"', '\"');
                String atype = tokens.readTillEol();
                int idx = atype.indexOf(37);
                if (idx != -1) {
                    atype = atype.substring(0, idx - 1);
                }
                atype = atype.trim();
                this.addAttribute(schema, aname, atype, attrMap);
                expected = 2;
            } else if (token.equals(TAG_NAME[2])) {
                if (expected != 2) {
                    throw new IOException(TAG_NAME[expected] + TAG_ERROR + token + "'");
                }
                this.m_DataLine = tokens.getLine();
                expected = 3;
            } else {
                throw new IOException(TAG_NAME[expected] + TAG_ERROR + token + "'");
            }
            if (expected >= 3) continue;
            token = tokens.getToken().toUpperCase();
        }
        return schema;
    }

    public void skipTillData() throws IOException {
        boolean error = false;
        MStreamTokenizer tokens = this.m_Reader.getTokens();
        String token = tokens.getToken().toUpperCase();
        while (token != null) {
            if (this.m_DataLine != -1 && tokens.getLine() > this.m_DataLine) {
                error = true;
                break;
            }
            if (token.equals(TAG_NAME[2])) break;
            token = tokens.getToken().toUpperCase();
        }
        if (token == null || error) {
            throw new IOException("Unexpected ARFF reader error looking for @data tag");
        }
    }

    protected void addAttribute(ClusSchema schema, String aname, String atype, HashMap<String, int[]> attrMap) throws IOException, ClusException {
        ClassesAttrType type;
        Settings sett = schema.getSettings();
        String uptype = atype.toUpperCase();
        while (attrMap.containsKey(aname)) {
            int[] cnt = attrMap.get(aname);
            int idx = cnt[0] = cnt[0] + 1;
            aname = aname + "-" + idx;
        }
        attrMap.put(aname, new int[1]);
        if (uptype.equals("NUMERIC") || uptype.equals("REAL") || uptype.equals("INTEGER")) {
            schema.addAttrType(new NumericAttrType(aname));
        } else if (uptype.equals("CLASSES")) {
            type = new ClassesAttrType(aname);
            schema.addAttrType(type);
            type.initSettings(schema.getSettings());
        } else if (uptype.startsWith("HIERARCHICAL")) {
            if (schema.getSettings().getHMLC().getHierSingleLabel()) {
                type = new ClassesAttrTypeSingleLabel(aname, atype);
                schema.addAttrType(type);
                type.initSettings(schema.getSettings());
            } else {
                type = new ClassesAttrType(aname, atype);
                schema.addAttrType(type);
                type.initSettings(schema.getSettings());
            }
        } else if (uptype.equals("STRING")) {
            schema.addAttrType(new StringAttrType(aname));
        } else if (uptype.equals("KEY")) {
            StringAttrType key = new StringAttrType(aname);
            schema.addAttrType(key);
            key.setStatus(ClusAttrType.Status.Key);
        } else if (uptype.equals("TIMESERIES")) {
            TimeSeriesAttrType tsat = new TimeSeriesAttrType(aname);
            schema.addAttrType(tsat);
        } else if (uptype.startsWith("TUPLE")) {
            TupleAttrType tupleat = (TupleAttrType)ClusAttrType.createClusAttrType(uptype, aname);
            schema.addAttrType(tupleat);
        } else if (uptype.startsWith("SET")) {
            SetAttrType setat = new SetAttrType(aname, uptype);
            schema.addAttrType(setat);
        } else {
            int tlen;
            if (uptype.equals("BINARY")) {
                atype = "{1,0}";
            }
            if ((tlen = atype.length()) > 2 && atype.charAt(0) == '{' && atype.charAt(tlen - 1) == '}') {
                if (sett.getAttribute().getReduceMemoryNominalAttrs()) {
                    schema.addAttrType(new BitwiseNominalAttrType(aname, atype));
                } else {
                    schema.addAttrType(new NominalAttrType(aname, atype));
                }
            } else {
                throw new IOException("Attribute '" + aname + "' has unknown type '" + atype + "'");
            }
        }
    }

    public static void writeArffHeader(PrintWriter wrt, ClusSchema schema) throws IOException, ClusException {
        wrt.println("@RELATION '" + StringUtils.removeSingleQuote(schema.getRelationName()) + "'");
        wrt.println();
        for (int i = 0; i < schema.getNbAttributes(); ++i) {
            ClusAttrType type = schema.getAttrType(i);
            if (type.isDisabled()) continue;
            wrt.print("@ATTRIBUTE ");
            wrt.print(StringUtils.printStr(type.getName(), 65));
            if (type.isKey()) {
                wrt.print("key");
            } else {
                type.writeARFFType(wrt);
            }
            wrt.println();
        }
        if (!schema.getSettings().getEnsemble().shouldWritePredictionsFromEnsemble()) {
            wrt.println();
        }
        wrt.flush();
    }

    public static RowData readArff(String fname) throws IOException, ClusException {
        ClusReader reader = new ClusReader(fname, null);
        ARFFFile arff = new ARFFFile(reader);
        ClusSchema schema = arff.read(null);
        schema.initialize();
        ClusView view = schema.createNormalView();
        RowData data = view.readData(reader, schema);
        reader.close();
        return data;
    }

    public static void writeArff(String fname, RowData data) throws IOException, ClusException {
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fname)));
        ClusSchema schema = data.getSchema();
        ARFFFile.writeArffHeader(wrt, schema);
        wrt.println("@DATA");
        for (int j = 0; j < data.getNbRows(); ++j) {
            DataTuple tuple = data.getTuple(j);
            tuple.writeTuple(wrt);
        }
        wrt.close();
    }

    public static void writeRDataNominalLabels(String fname, RowData data) throws IOException, ClusException {
        ClusSchema schema = data.getSchema();
        int nbAttr = schema.getNbAttributes();
        ArrayList<Integer> nominalAttrs = new ArrayList<Integer>();
        for (int iColumn = 0; iColumn < nbAttr; ++iColumn) {
            ClusAttrType attrType = schema.getAttrType(iColumn);
            if (!(attrType instanceof NominalAttrType)) continue;
            nominalAttrs.add(iColumn + 1);
        }
        if (nominalAttrs.size() > 0) {
            PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fname)));
            for (int iColumn = 0; iColumn < nominalAttrs.size(); ++iColumn) {
                wrt.print(nominalAttrs.get(iColumn) + "\t");
            }
            wrt.print("\n");
            wrt.close();
        }
    }
}

