/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.io.ClusView;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.BitwiseNominalAttrType;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.IndexAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.data.type.primitive.SparseNumericAttrType;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRHierarchy;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.selection.XValDataSelection;
import si.ijs.kt.clus.selection.XValMainSelection;
import si.ijs.kt.clus.selection.XValRandomSelection;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.io.DummySerializable;
import si.ijs.kt.clus.util.jeans.util.IntervalCollection;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClusSchema
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final int ROWS = 0;
    public static final int COLS = 1;
    protected boolean m_IsSparse;
    protected String m_Relation;
    protected int m_NbAttrs;
    protected int m_NbInts;
    protected int m_NbDoubles;
    protected int m_NbObjects;
    protected ArrayList<ClusAttrType> m_Attr = new ArrayList();
    protected ClusAttrType[][] m_AllAttrUse;
    protected NominalAttrType[][] m_NominalAttrUse;
    protected NumericAttrType[][] m_NumericAttrUse;
    protected TimeSeriesAttrType[][] m_TimeSeriesAttrUse;
    protected ClusAttrType[] m_NonSparse;
    protected Settings m_Settings;
    protected IndexAttrType m_TSAttr;
    protected IntervalCollection m_Target = IntervalCollection.EMPTY;
    protected IntervalCollection m_Disabled = IntervalCollection.EMPTY;
    protected IntervalCollection m_Clustering = IntervalCollection.EMPTY;
    protected IntervalCollection m_Descriptive = IntervalCollection.EMPTY;
    protected IntervalCollection m_GIS = IntervalCollection.EMPTY;
    protected IntervalCollection m_Key = IntervalCollection.EMPTY;
    protected int[] m_NbVt;
    protected int m_NbHMTRAttributes;
    private ClusHMTRHierarchy m_HMTRHierarchy;

    public ClusSchema(String name) {
        this.m_Relation = name;
    }

    public ClusSchema(String name, String descr) {
        this.m_Relation = name;
        this.addFromString(descr);
    }

    public void setSettings(Settings sett) {
        this.m_Settings = sett;
    }

    public void initializeSettings(Settings sett) throws ClusException, IOException {
        this.setSettings(sett);
        this.setTestSet(-1);
        this.setTarget(new IntervalCollection(sett.getAttribute().getTarget()));
        this.setDisabled(new IntervalCollection(sett.getAttribute().getDisabled()));
        this.setClustering(new IntervalCollection(sett.getAttribute().getClustering()));
        this.setDescriptive(new IntervalCollection(sett.getAttribute().getDescriptive()));
        this.setGIS(new IntervalCollection(sett.getAttribute().getGIS()));
        this.setKey(new IntervalCollection(sett.getAttribute().getKey()));
        this.updateAttributeUse();
        this.addIndices(0);
    }

    public void initialize() throws ClusException, IOException {
        this.updateAttributeUse();
        this.addIndices(0);
    }

    public Settings getSettings() {
        return this.m_Settings;
    }

    public final String getRelationName() {
        return this.m_Relation;
    }

    public final void setRelationName(String name) {
        this.m_Relation = name;
    }

    public ClusSchema cloneSchema() {
        ClusSchema result = new ClusSchema(this.getRelationName());
        result.setSettings(this.getSettings());
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType attr = this.getAttrType(i);
            ClusAttrType copy = attr.cloneType();
            result.addAttrType(copy);
        }
        return result;
    }

    public final int getNbAttributes() {
        return this.m_NbAttrs;
    }

    public final ClusAttrType getAttrType(int idx) {
        return this.m_Attr.get(idx);
    }

    public final ClusAttrType getAttrType(String name) {
        for (int j = 0; j < this.m_NbAttrs; ++j) {
            ClusAttrType attr = this.m_Attr.get(j);
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public final ClusAttrType[] getAllAttrUse(ClusAttrType.AttributeUseType attruse) {
        return this.m_AllAttrUse[attruse.getIndex()];
    }

    public final int getNbAllAttrUse(ClusAttrType.AttributeUseType attruse) {
        return this.m_AllAttrUse[attruse.getIndex()].length;
    }

    public TimeSeriesAttrType[] getTimeSeriesAttrUse(ClusAttrType.AttributeUseType attruse) {
        return this.m_TimeSeriesAttrUse[attruse.getIndex()];
    }

    public final NominalAttrType[] getNominalAttrUse(ClusAttrType.AttributeUseType attruse) {
        return this.m_NominalAttrUse[attruse.getIndex()];
    }

    public final int getNbNominalAttrUse(ClusAttrType.AttributeUseType attruse) {
        return this.m_NominalAttrUse[attruse.getIndex()].length;
    }

    public final NumericAttrType[] getNumericAttrUse(ClusAttrType.AttributeUseType attruse) {
        return this.m_NumericAttrUse[attruse.getIndex()];
    }

    public final int getNbNumericAttrUse(ClusAttrType.AttributeUseType attruse) {
        return this.m_NumericAttrUse[attruse.getIndex()].length;
    }

    public final ClusAttrType[] getDescriptiveAttributes() {
        return this.m_AllAttrUse[ClusAttrType.AttributeUseType.Descriptive.getIndex()];
    }

    public final ClusAttrType[] getKeyAttribute() {
        return this.m_AllAttrUse[ClusAttrType.AttributeUseType.Key.getIndex()];
    }

    public final int getNbDescriptiveAttributes() {
        return this.getNbAllAttrUse(ClusAttrType.AttributeUseType.Descriptive);
    }

    public final ClusAttrType[] getTargetAttributes() {
        return this.m_AllAttrUse[ClusAttrType.AttributeUseType.Target.getIndex()];
    }

    public final int getNbTargetAttributes() {
        return this.getNbAllAttrUse(ClusAttrType.AttributeUseType.Target);
    }

    public final ClusAttrType[] getClusteringAttributes() {
        return this.m_AllAttrUse[ClusAttrType.AttributeUseType.Clustering.getIndex()];
    }

    public final int getNbClusteringAttributes() {
        return this.getNbNumericAttrUse(ClusAttrType.AttributeUseType.Clustering);
    }

    public final int getNbNominalDescriptiveAttributes() {
        return this.getNbNominalAttrUse(ClusAttrType.AttributeUseType.Descriptive);
    }

    public final int getNbNumericDescriptiveAttributes() {
        return this.getNbNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive);
    }

    public final int getNbNominalTargetAttributes() {
        return this.getNbNominalAttrUse(ClusAttrType.AttributeUseType.Target);
    }

    public final int getNbNumericTargetAttributes() {
        return this.getNbNumericAttrUse(ClusAttrType.AttributeUseType.Target);
    }

    public final int getNbInts() {
        return this.m_NbInts;
    }

    public final int getNbDoubles() {
        return this.m_NbDoubles;
    }

    public final int getNbObjects() {
        return this.m_NbObjects;
    }

    public final boolean hasAttributeType(ClusAttrType.AttributeUseType attruse, ClusAttrType.AttributeType attrtype) {
        ClusAttrType[] all = this.getAllAttrUse(attruse);
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].getAttributeType().equals((Object)attrtype)) continue;
            return true;
        }
        return false;
    }

    public ClusAttrType getLastNonDisabledType() {
        int nb;
        for (nb = this.getNbAttributes() - 1; nb >= 0 && this.getAttrType(nb).isDisabled(); --nb) {
        }
        if (nb >= 0) {
            return this.getAttrType(nb);
        }
        return null;
    }

    public final void addAttrType(ClusAttrType attr) {
        this.m_Attr.add(attr);
        attr.setIndex(this.m_NbAttrs++);
        attr.setSchema(this);
    }

    public final void setAttrType(ClusAttrType attr, int idx) {
        this.m_Attr.set(idx, attr);
        attr.setIndex(idx);
        attr.setSchema(this);
    }

    public final void addFromString(String descr) {
        StringTokenizer tokens = new StringTokenizer(descr, "[]");
        while (tokens.hasMoreTokens()) {
            String name;
            String type = tokens.nextToken();
            String string = name = tokens.hasMoreTokens() ? tokens.nextToken() : "";
            if (!type.equals("f")) continue;
            this.addAttrType(new NumericAttrType(name));
        }
    }

    public final boolean hasMissing() {
        for (int j = 0; j < this.m_NbAttrs; ++j) {
            ClusAttrType attr = this.m_Attr.get(j);
            if (!attr.hasMissing()) continue;
            return true;
        }
        return false;
    }

    public final double getTotalInputNbMissing() {
        int nb_miss = 0;
        ClusAttrType[] attrs = this.getDescriptiveAttributes();
        for (int j = 0; j < attrs.length; ++j) {
            ClusAttrType at = attrs[j];
            nb_miss += at.getNbMissing();
        }
        return nb_miss;
    }

    public final IntervalCollection getTarget() {
        return this.m_Target;
    }

    public final IntervalCollection getDisabled() {
        return this.m_Disabled;
    }

    public final IntervalCollection getClustering() {
        return this.m_Clustering;
    }

    public final IntervalCollection getDescriptive() {
        return this.m_Descriptive;
    }

    public final void setTarget(IntervalCollection coll) {
        this.m_Target = coll;
    }

    public final void setDisabled(IntervalCollection coll) {
        this.m_Disabled = coll;
    }

    public final void setClustering(IntervalCollection coll) {
        this.m_Clustering = coll;
    }

    public final void setDescriptive(IntervalCollection coll) {
        this.m_Descriptive = coll;
    }

    public void setGIS(IntervalCollection m_gis) {
        this.m_GIS = m_gis;
    }

    public final void setKey(IntervalCollection coll) {
        this.m_Key = coll;
    }

    public final void updateAttributeUse() throws ClusException, IOException {
        boolean[] keys = new boolean[this.getNbAttributes() + 1];
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType type = this.getAttrType(i);
            if (!type.getStatus().equals((Object)ClusAttrType.Status.Key)) continue;
            keys[type.getIndex() + 1] = true;
        }
        this.m_Key.add(keys);
        if (this.m_Target.isDefault()) {
            int target;
            this.m_Target.clear();
            boolean[] bits = new boolean[this.getNbAttributes() + 1];
            this.m_Disabled.toBits(bits);
            for (target = bits.length - 1; target >= 0 && (bits[target] || keys[target]); --target) {
            }
            if (target > 0) {
                this.m_Target.addInterval(target, target);
            }
        } else {
            this.m_Disabled.subtract(this.m_Target);
        }
        if (this.m_Clustering.isDefault()) {
            this.m_Clustering.copyFrom(this.m_Target);
        } else {
            this.m_Disabled.subtract(this.m_Clustering);
        }
        if (this.m_Descriptive.isDefault()) {
            this.m_Descriptive.clear();
            this.m_Descriptive.addInterval(1, this.getNbAttributes());
            this.m_Descriptive.subtract(this.m_Target);
            this.m_Descriptive.subtract(this.m_Disabled);
            this.m_Descriptive.subtract(this.m_Key);
        } else {
            this.m_Disabled.subtract(this.m_Descriptive);
        }
        this.m_Disabled.subtract(this.m_Key);
        this.checkRange(this.m_Key, "key");
        this.checkRange(this.m_Disabled, "disabled");
        this.checkRange(this.m_Target, "target");
        this.checkRange(this.m_GIS, "GIS");
        this.checkRange(this.m_Clustering, "clustering");
        this.checkRange(this.m_Descriptive, "descriptive");
        this.setStatusAll(ClusAttrType.Status.Normal);
        this.setStatus(this.m_Disabled, ClusAttrType.Status.Disabled, true);
        this.setStatus(this.m_Target, ClusAttrType.Status.Target, true);
        this.setStatus(this.m_Clustering, ClusAttrType.Status.ClusterNoTarget, false);
        this.setStatus(this.m_GIS, ClusAttrType.Status.GIS, true);
        this.setStatus(this.m_Key, ClusAttrType.Status.Key, true);
        this.setDescriptiveAll(false);
        this.setDescriptive(this.m_Descriptive, true);
        this.setClusteringAll(false);
        this.setClustering(this.m_Clustering, true);
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType at = this.getAttrType(i);
            at.initializeBeforeLoadingData();
        }
    }

    public void clearAttributeStatusClusteringAndTarget() {
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType at = this.getAttrType(i);
            if (at.getStatus().equals((Object)ClusAttrType.Status.Disabled) || at.getStatus().equals((Object)ClusAttrType.Status.Key)) continue;
            at.setStatus(ClusAttrType.Status.Normal);
        }
        this.setClusteringAll(false);
    }

    public void initDescriptiveAttributes() {
        this.setDescriptiveAll(false);
        this.setDescriptive(this.m_Descriptive, true);
    }

    public final void checkRange(IntervalCollection coll, String type) throws ClusException {
        if (coll.getMinIndex() < 0) {
            throw new ClusException("Range for " + type + " attributes goes below zero: '" + coll + "'");
        }
        if (coll.getMaxIndex() > this.getNbAttributes()) {
            throw new ClusException("Range for " + type + " attributes: '" + coll + "' out of range (there are only " + this.getNbAttributes() + " attributes)");
        }
    }

    public final void setStatus(IntervalCollection coll, ClusAttrType.Status status, boolean force) {
        coll.reset();
        while (coll.hasMoreInts()) {
            ClusAttrType at = this.getAttrType(coll.nextInt() - 1);
            if (!force && !at.getStatus().equals((Object)ClusAttrType.Status.Normal)) continue;
            at.setStatus(status);
        }
    }

    public final void setStatusAll(ClusAttrType.Status status) {
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType at = this.getAttrType(i);
            at.setStatus(status);
        }
    }

    public final void setDescriptive(IntervalCollection coll, boolean descr) {
        coll.reset();
        while (coll.hasMoreInts()) {
            ClusAttrType at = this.getAttrType(coll.nextInt() - 1);
            at.setDescriptive(descr);
        }
    }

    public final void setDescriptiveAll(boolean descr) {
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType at = this.getAttrType(i);
            at.setDescriptive(descr);
        }
    }

    public final void setClustering(IntervalCollection coll, boolean clust) {
        coll.reset();
        while (coll.hasMoreInts()) {
            ClusAttrType at = this.getAttrType(coll.nextInt() - 1);
            at.setClustering(clust);
        }
    }

    public final void setClusteringAll(boolean clust) {
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType at = this.getAttrType(i);
            at.setClustering(clust);
        }
    }

    public final void addIndices(int type) throws ClusException {
        if (type == 1) {
            this.addColsIndex();
        } else {
            this.addRowsIndex();
        }
    }

    public final void showDebug() {
        ClusLogger.info("Nb ints: " + this.getNbInts());
        ClusLogger.info("Nb double: " + this.getNbDoubles());
        ClusLogger.info("Nb obj: " + this.getNbObjects());
        ClusLogger.info("Idx   Name                          Descr Status    Ref   Type             Sparse Missing");
        for (int j = 0; j < this.m_NbAttrs; ++j) {
            ClusAttrType at = this.m_Attr.get(j);
            System.out.print(StringUtils.printInt(j + 1, 6));
            System.out.print(StringUtils.printStrMax(at.getName(), 29));
            if (at.isDescriptive()) {
                System.out.print(" Yes   ");
            } else {
                System.out.print(" No    ");
            }
            switch (at.getStatus()) {
                case Normal: {
                    System.out.print("          ");
                    break;
                }
                case Disabled: {
                    System.out.print("Disabled  ");
                    break;
                }
                case GIS: {
                    System.out.print("GIS    ");
                    break;
                }
                case Target: {
                    System.out.print("Target    ");
                    break;
                }
                case ClusterNoTarget: {
                    System.out.print("Cluster   ");
                    break;
                }
                case Key: {
                    System.out.print("Key       ");
                    break;
                }
                default: {
                    System.out.print("Error     ");
                }
            }
            System.out.print(StringUtils.printInt(at.getArrayIndex(), 6));
            System.out.print(StringUtils.printStr(at.getTypeName(), 16));
            if (at instanceof NumericAttrType) {
                if (((NumericAttrType)at).isSparse()) {
                    System.out.print(" Yes");
                } else {
                    System.out.print(" No ");
                }
            } else {
                System.out.print(" ?  ");
            }
            System.out.print("    ");
            System.out.print(StringUtils.printStr(ClusFormat.TWO_AFTER_DOT.format(at.getNbMissing()), 8));
            ClusLogger.info();
        }
    }

    public final boolean isRegression() {
        return this.getNbNumericTargetAttributes() > 0;
    }

    public final void setReader(boolean start_stop) {
        for (int j = 0; j < this.m_NbAttrs; ++j) {
            ClusAttrType attr = this.m_Attr.get(j);
            if (attr.getStatus().equals((Object)ClusAttrType.Status.Disabled)) continue;
            attr.setReader(start_stop);
        }
    }

    public final void getPreprocs(DataPreprocs pps, boolean single) {
        for (int j = 0; j < this.m_NbAttrs; ++j) {
            ClusAttrType attr = this.m_Attr.get(j);
            if (attr.getStatus().equals((Object)ClusAttrType.Status.Disabled)) continue;
            attr.getPreprocs(pps, single);
        }
    }

    public final int getMaxNbStats() {
        int max = 0;
        ClusAttrType[] descr = this.getAllAttrUse(ClusAttrType.AttributeUseType.Descriptive);
        for (int i = 0; i < descr.length; ++i) {
            max = Math.max(descr[i].getMaxNbStats(), max);
        }
        return max;
    }

    public final XValMainSelection getXValSelection(ClusData data) throws ClusException {
        if (this.m_TSAttr == null) {
            return new XValRandomSelection(data.getNbRows(), this.getSettings().getData().getXValFolds());
        }
        return new XValDataSelection(this.m_TSAttr);
    }

    public final void setTestSet(int id) {
        if (id != -1) {
            ClusLogger.info("Setting test set ID: " + id);
            ClusAttrType type = this.m_Attr.get(id);
            this.m_TSAttr = new IndexAttrType(type.getName());
            this.m_Attr.set(id, this.m_TSAttr);
        }
    }

    public final void attachModel(ClusModel model) throws ClusException {
        HashMap<String, ClusAttrType> table = this.buildAttributeHash();
        model.attachModel(table);
    }

    public final HashMap<String, ClusAttrType> buildAttributeHash() throws ClusException {
        HashMap<String, ClusAttrType> hash = new HashMap<String, ClusAttrType>();
        for (int j = 0; j < this.m_NbAttrs; ++j) {
            ClusAttrType at = this.m_Attr.get(j);
            if (hash.containsKey(at.getName())) {
                throw new ClusException("Duplicate attribute name: '" + at.getName() + "'");
            }
            hash.put(at.getName(), at);
        }
        return hash;
    }

    public void initializeFrom(ClusSchema schema) throws ClusException {
        if (schema.isSparse()) {
            this.ensureSparse();
        }
        int this_nb = this.getNbAttributes();
        int other_nb = schema.getNbAttributes();
        if (other_nb > this_nb) {
            throw new ClusException("To few attributes in data set " + this_nb + " < " + other_nb);
        }
        for (int i = 0; i < other_nb; ++i) {
            ClusAttrType this_type = this.getAttrType(i);
            ClusAttrType other_type = schema.getAttrType(i);
            if (!this_type.getName().equals(other_type.getName())) {
                throw new ClusException("Attribute names do not align: '" + other_type.getName() + "' expected at position " + (i + 1) + " but found '" + this_type.getName() + "'");
            }
            if (this_type.getClass() != other_type.getClass()) {
                throw new ClusException("Attribute types do not match for '" + other_type.getName() + "' expected '" + other_type.getClass().getName() + "' but found '" + this_type.getClass().getName() + "'");
            }
            this_type.initializeFrom(other_type);
        }
    }

    private void addColsIndex() {
        int idx = 0;
        for (int j = 0; j < this.m_NbAttrs; ++j) {
            ClusAttrType at = this.m_Attr.get(j);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Normal)) continue;
            at.setArrayIndex(idx++);
        }
    }

    public static ClusAttrType[] vectorToAttrArray(ArrayList list) {
        ClusAttrType[] res = new ClusAttrType[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = (ClusAttrType)list.get(i);
        }
        return res;
    }

    public static NominalAttrType[] vectorToNominalAttrArray(ArrayList list) {
        NominalAttrType[] res = new NominalAttrType[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = (NominalAttrType)list.get(i);
        }
        return res;
    }

    public static NumericAttrType[] vectorToNumericAttrArray(ArrayList list) {
        NumericAttrType[] res = new NumericAttrType[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = (NumericAttrType)list.get(i);
        }
        return res;
    }

    public static TimeSeriesAttrType[] vectorToTimeSeriesAttrArray(ArrayList list) {
        TimeSeriesAttrType[] res = new TimeSeriesAttrType[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = (TimeSeriesAttrType)list.get(i);
        }
        return res;
    }

    public ArrayList collectAttributes(ClusAttrType.AttributeUseType attruse, ClusAttrType.AttributeType attrtype) {
        ArrayList<ClusAttrType> result = new ArrayList<ClusAttrType>();
        block8: for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType type = this.getAttrType(i);
            if (attrtype != null && !attrtype.equals((Object)type.getAttributeType())) continue;
            switch (attruse) {
                case All: {
                    if (type.getStatus().equals((Object)ClusAttrType.Status.Disabled) || type.getStatus().equals((Object)ClusAttrType.Status.Key)) continue block8;
                    result.add(type);
                    continue block8;
                }
                case Clustering: {
                    if (!type.isClustering()) continue block8;
                    result.add(type);
                    continue block8;
                }
                case Descriptive: {
                    if (!type.isDescriptive()) continue block8;
                    result.add(type);
                    continue block8;
                }
                case Target: {
                    if (!type.isTarget()) continue block8;
                    result.add(type);
                    continue block8;
                }
                case Key: {
                    if (!type.isKey()) continue block8;
                    result.add(type);
                    continue block8;
                }
                case GIS: {
                    if (!type.isGIS()) continue block8;
                    result.add(type);
                }
            }
        }
        return result;
    }

    public boolean isSparse() {
        return this.m_IsSparse;
    }

    public void setSparse() {
        this.m_IsSparse = true;
    }

    public ClusAttrType[] getNonSparseAttributes() {
        return this.m_NonSparse;
    }

    public void ensureSparse() {
        if (!this.m_IsSparse) {
            int nbSparse = 0;
            ArrayList<ClusAttrType> nonSparse = new ArrayList<ClusAttrType>();
            for (int i = 0; i < this.getNbAttributes(); ++i) {
                ClusAttrType type = this.getAttrType(i);
                if (type.isDescriptive() && type.getAttributeType().equals((Object)ClusAttrType.AttributeType.Numeric)) {
                    SparseNumericAttrType nt = new SparseNumericAttrType((NumericAttrType)type);
                    nt.setStatus(type.getStatus());
                    nt.setDescriptive(true);
                    this.setAttrType(nt, i);
                    ++nbSparse;
                    continue;
                }
                nonSparse.add(type);
            }
            this.m_NonSparse = ClusSchema.vectorToAttrArray(nonSparse);
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Number of sparse attributes: " + nbSparse);
            }
            this.addRowsIndex();
            this.m_IsSparse = true;
        }
    }

    public void printInfo() {
        if (this.getSettings().getGeneral().getVerbose() >= 1) {
            ClusLogger.info("Space required by nominal attributes: " + this.m_NbVt[ClusAttrType.ValueType.Int.getIndex()] * 4 + " bytes/tuple regular, " + this.m_NbVt[ClusAttrType.ValueType.BitwiseInt.getIndex()] * 4 + " bytes/tuple bitwise");
        }
    }

    protected void addRowsIndex() {
        this.m_NbVt = new int[ClusAttrType.ValueType.values().length];
        int bitPosition = 0;
        int nbBitwise = 0;
        for (int j = 0; j < this.m_NbAttrs; ++j) {
            int sidx;
            ClusAttrType at = this.m_Attr.get(j);
            ClusAttrType.ValueType vtype = at.getValueType();
            if (vtype.equals((Object)ClusAttrType.ValueType.None) || at.getStatus().equals((Object)ClusAttrType.Status.Disabled)) {
                at.setArrayIndex(-1);
                continue;
            }
            if (!vtype.equals((Object)ClusAttrType.ValueType.BitwiseInt)) {
                int sidx2;
                int n = vtype.getIndex();
                this.m_NbVt[n] = this.m_NbVt[n] + 1;
                at.setArrayIndex(sidx2);
                continue;
            }
            ++nbBitwise;
            BitwiseNominalAttrType bat = (BitwiseNominalAttrType)at;
            int nextBitPosition = bitPosition + bat.getNbBits();
            if (nextBitPosition > 32) {
                int n = vtype.getIndex();
                this.m_NbVt[n] = this.m_NbVt[n] + 1;
                sidx = this.m_NbVt[vtype.getIndex()];
                bat.setArrayIndex(sidx);
                bat.setBitPosition(0);
                bitPosition = bat.getNbBits();
                continue;
            }
            sidx = this.m_NbVt[vtype.getIndex()];
            bat.setArrayIndex(sidx);
            bat.setBitPosition(bitPosition);
            bitPosition = nextBitPosition;
        }
        if (nbBitwise > 0) {
            int n = ClusAttrType.ValueType.BitwiseInt.getIndex();
            this.m_NbVt[n] = this.m_NbVt[n] + 1;
        }
        this.m_NbInts = Math.max(this.m_NbVt[ClusAttrType.ValueType.Int.getIndex()], this.m_NbVt[ClusAttrType.ValueType.BitwiseInt.getIndex()]);
        this.m_NbDoubles = this.m_NbVt[ClusAttrType.ValueType.Double.getIndex()];
        this.m_NbObjects = this.m_NbVt[ClusAttrType.ValueType.Object.getIndex()];
        int nb = ClusAttrType.AttributeUseType.values().length;
        this.m_AllAttrUse = new ClusAttrType[nb][];
        this.m_NominalAttrUse = new NominalAttrType[nb][];
        this.m_NumericAttrUse = new NumericAttrType[nb][];
        this.m_TimeSeriesAttrUse = new TimeSeriesAttrType[nb][];
        for (ClusAttrType.AttributeUseType attruse : ClusAttrType.AttributeUseType.values()) {
            this.m_AllAttrUse[attruse.getIndex()] = ClusSchema.vectorToAttrArray(this.collectAttributes(attruse, null));
            this.m_NominalAttrUse[attruse.getIndex()] = ClusSchema.vectorToNominalAttrArray(this.collectAttributes(attruse, ClusAttrType.AttributeType.Nominal));
            this.m_NumericAttrUse[attruse.getIndex()] = ClusSchema.vectorToNumericAttrArray(this.collectAttributes(attruse, ClusAttrType.AttributeType.Numeric));
            this.m_TimeSeriesAttrUse[attruse.getIndex()] = ClusSchema.vectorToTimeSeriesAttrArray(this.collectAttributes(attruse, ClusAttrType.AttributeType.TimeSeries));
        }
    }

    public DataTuple createTuple() {
        return this.m_IsSparse ? new SparseDataTuple(this) : new DataTuple(this);
    }

    public ClusView createNormalView() throws ClusException {
        ClusView view = new ClusView();
        this.createNormalView(view);
        return view;
    }

    public void createNormalView(ClusView view) throws ClusException {
        int nb = this.getNbAttributes();
        for (int j = 0; j < nb; ++j) {
            ClusAttrType at = this.getAttrType(j);
            ClusAttrType.Status status = at.getStatus();
            if (status.equals((Object)ClusAttrType.Status.Disabled)) {
                view.addAttribute(new DummySerializable());
                continue;
            }
            view.addAttribute(at.createRowSerializable());
        }
    }

    public String toString() {
        int aidx = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            ClusAttrType type = this.getAttrType(i);
            if (type.isDisabled()) continue;
            if (aidx != 0) {
                buf.append(",");
            }
            buf.append(type.getName());
            ++aidx;
        }
        return buf.toString();
    }

    public ArrayList<ClusAttrType> getAttr() {
        return this.m_Attr;
    }

    public void setHMTRHierarchy(ClusHMTRHierarchy HMTRHierarchy) {
        this.m_HMTRHierarchy = HMTRHierarchy;
    }

    public ClusHMTRHierarchy getHMTRHierarchy() {
        return this.m_HMTRHierarchy;
    }

    public int getNbHMTRAttributes() {
        return this.m_NbHMTRAttributes;
    }

    public void setNbHMTRAttributes(int nbHMTR) {
        this.m_NbHMTRAttributes = nbHMTR;
    }
}

