/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.tdidt;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.DepthFirstInduce;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.data.type.primitive.SparseNumericAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandomNonstatic;
import si.ijs.kt.clus.util.exception.ClusException;

public class DepthFirstInduceSparse
extends DepthFirstInduce {
    public DepthFirstInduceSparse(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
        if (this.getSettings().getGeneral().getVerbose() > 0) {
            ClusLogger.info("Sparse implementation");
        }
    }

    public DepthFirstInduceSparse(ClusInductionAlgorithm other) {
        super(other);
        if (this.getSettings().getGeneral().getVerbose() > 0) {
            ClusLogger.info("Sparse implementation");
        }
    }

    public DepthFirstInduceSparse(ClusInductionAlgorithm other, NominalSplit split) {
        super(other);
        if (this.getSettings().getGeneral().getVerbose() > 0) {
            ClusLogger.info("Sparse implementation");
        }
    }

    public DepthFirstInduceSparse(ClusInductionAlgorithm other, ClusStatManager mgr, boolean parallelism) {
        super(other, mgr, parallelism);
        if (this.getSettings().getGeneral().getVerbose() > 0) {
            ClusLogger.info("Sparse implementation");
        }
    }

    public void initializeExamples(ClusAttrType[] attrs, RowData data) {
        int i;
        for (i = 0; i < attrs.length; ++i) {
            ClusAttrType at = attrs[i];
            if (!at.isSparse()) continue;
            ((SparseNumericAttrType)at).resetExamples();
        }
        for (i = 0; i < data.getNbRows(); ++i) {
            SparseDataTuple tuple = (SparseDataTuple)data.getTuple(i);
            tuple.addExampleToAttributes();
        }
    }

    @Override
    public void induce(ClusNode node, RowData data, ClusRandomNonstatic rnd) throws Exception {
        if (this.getSettings().getEnsemble().isEnsembleMode() && (this.getSettings().getEnsemble().getEnsembleMethod() == SettingsEnsemble.EnsembleMethod.RForest || this.getSettings().getEnsemble().getEnsembleMethod() == SettingsEnsemble.EnsembleMethod.RFeatSelection)) {
            this.induceRandomForest(node, data, rnd);
        } else {
            ClusAttrType[] attrs = this.getDescriptiveAttributes(rnd);
            this.initializeExamples(attrs, data);
            ArrayList<ClusAttrType> attrList = new ArrayList<ClusAttrType>();
            for (int i = 0; i < attrs.length; ++i) {
                ClusAttrType at = attrs[i];
                if (at.isSparse()) {
                    if (!(((SparseNumericAttrType)at).getExampleWeight() >= this.getSettings().getModel().getMinimalWeight())) continue;
                    attrList.add(at);
                    continue;
                }
                attrList.add(at);
            }
            Object[] attrArray = attrList.toArray();
            this.induce(node, data, attrArray, rnd);
        }
    }

    public void induce(ClusNode node, RowData data, Object[] attrs, ClusRandomNonstatic rnd) throws Exception {
        if (this.getSettings().getGeneral().getVerbose() >= SHOW_INDUCE_PROGRESS) {
            ClusLogger.info("Depth " + node.getLevel() + ": inducing new node: " + attrs.length + " attributes, " + data.getNbRows() + " examples");
        }
        if (this.initSelectorAndStopCrit(node, data)) {
            this.makeLeaf(node);
            return;
        }
        boolean isExtraTreesEnsemble = this.getSettings().getEnsemble().isEnsembleMode() && this.getSettings().getEnsemble().getEnsembleMethod().equals((Object)SettingsEnsemble.EnsembleMethod.ExtraTrees);
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = (ClusAttrType)attrs[i];
            if (isExtraTreesEnsemble) {
                if (at.isNominal()) {
                    this.m_FindBestTest.findNominalExtraTree((NominalAttrType)at, data, rnd);
                    continue;
                }
                this.m_FindBestTest.findNumericExtraTree((NumericAttrType)at, data, rnd);
                continue;
            }
            if (at.isNominal()) {
                this.m_FindBestTest.findNominal((NominalAttrType)at, data, rnd);
                continue;
            }
            this.m_FindBestTest.findNumeric((NumericAttrType)at, data, rnd);
        }
        CurrentBestTestAndHeuristic best = this.m_FindBestTest.getBestTest();
        if (best.hasBestTest()) {
            int j;
            node.testToNode(best);
            if (this.getSettings().getGeneral().getVerbose() >= SHOW_INDUCE_PROGRESS) {
                ClusLogger.info("Test: " + node.getTestString() + " -> " + best.getHeuristicValue());
            }
            int arity = node.updateArity();
            NodeTest test = node.getTest();
            RowData[] subsets = new RowData[arity];
            for (j = 0; j < arity; ++j) {
                subsets[j] = data.applyWeighted(test, j);
            }
            if (this.getSettings().getTree().showAlternativeSplits()) {
                this.filterAlternativeSplits(node, data, subsets);
            }
            if (node != this.m_Root && this.getSettings().getTree().hasTreeOptimize(SettingsTree.TreeOptimizeValues.NoInodeStats)) {
                node.setClusteringStat(null);
                node.setTargetStat(null);
            }
            for (j = 0; j < arity; ++j) {
                ClusNode child = new ClusNode();
                node.setChild(child, j);
                child.initClusteringStat(this.m_StatManager, this.m_Root.getClusteringStat(), subsets[j]);
                child.initTargetStat(this.m_StatManager, this.m_Root.getTargetStat(), subsets[j]);
                ArrayList<ClusAttrType> attrList = new ArrayList<ClusAttrType>();
                for (int i = 0; i < attrs.length; ++i) {
                    ClusAttrType at = (ClusAttrType)attrs[i];
                    if (at.isSparse()) {
                        double exampleWeight = this.getExampleWeight(subsets[j], (SparseNumericAttrType)at);
                        if (!(exampleWeight >= this.getSettings().getModel().getMinimalWeight())) continue;
                        attrList.add(at);
                        continue;
                    }
                    attrList.add(at);
                }
                Object[] attrArray = attrList.toArray();
                this.induce(child, subsets[j], attrArray, rnd);
            }
        } else {
            this.makeLeaf(node);
        }
        if (this.getSettings().getGeneral().getVerbose() >= SHOW_INDUCE_PROGRESS) {
            ClusLogger.info("Depth " + node.getLevel() + ": node finished.");
        }
    }

    @Deprecated
    public double getExampleWeight(ArrayList examples) {
        double weight = 0.0;
        for (int i = 0; i < examples.size(); ++i) {
            SparseDataTuple tup = (SparseDataTuple)examples.get(i);
            weight += tup.getWeight();
        }
        return weight;
    }

    public double getExampleWeight(RowData subset, SparseNumericAttrType attr) {
        double weight = 0.0;
        for (int i = 0; i < subset.getNbRows(); ++i) {
            SparseDataTuple tup = (SparseDataTuple)subset.getTuple(i);
            if (!(Math.abs(attr.getNumeric(tup)) > 1.0E-9)) continue;
            weight += tup.getWeight();
        }
        return weight;
    }

    public void induceRandomForest(ClusNode node, RowData data, ClusRandomNonstatic rnd) throws Exception {
        ClusAttrType[] attrs = this.getSchema().getDescriptiveAttributes();
        this.initializeExamples(attrs, data);
        this.induceRandomForestRecursive(node, data, rnd);
    }

    public void induceRandomForestRecursive(ClusNode node, RowData data, ClusRandomNonstatic rnd) throws Exception {
        ClusAttrType[] attrs = this.getDescriptiveAttributes(rnd);
        ArrayList<ClusAttrType> attrList = new ArrayList<ClusAttrType>();
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = attrs[i];
            if (at.isSparse()) {
                if (!(((SparseNumericAttrType)at).getExampleWeight() >= this.getSettings().getModel().getMinimalWeight())) continue;
                attrList.add(at);
                continue;
            }
            attrList.add(at);
        }
        Object[] attrArray = attrList.toArray();
        this.induceRandomForestRecursive2(node, data, attrArray, rnd);
    }

    public void induceRandomForestRecursive2(ClusNode node, RowData data, Object[] attrs, ClusRandomNonstatic rnd) throws Exception {
        if (this.initSelectorAndStopCrit(node, data)) {
            this.makeLeaf(node);
            return;
        }
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = (ClusAttrType)attrs[i];
            if (at.isNominal()) {
                this.m_FindBestTest.findNominal((NominalAttrType)at, data, rnd);
                continue;
            }
            this.m_FindBestTest.findNumeric((NumericAttrType)at, data, rnd);
        }
        CurrentBestTestAndHeuristic best = this.m_FindBestTest.getBestTest();
        if (best.hasBestTest()) {
            int j;
            node.testToNode(best);
            if (this.getSettings().getGeneral().getVerbose() > 1) {
                ClusLogger.info("Test: " + node.getTestString() + " -> " + best.getHeuristicValue());
            }
            int arity = node.updateArity();
            NodeTest test = node.getTest();
            RowData[] subsets = new RowData[arity];
            for (j = 0; j < arity; ++j) {
                subsets[j] = data.applyWeighted(test, j);
            }
            if (this.getSettings().getTree().showAlternativeSplits()) {
                this.filterAlternativeSplits(node, data, subsets);
            }
            if (node != this.m_Root && this.getSettings().getTree().hasTreeOptimize(SettingsTree.TreeOptimizeValues.NoInodeStats)) {
                node.setClusteringStat(null);
                node.setTargetStat(null);
            }
            for (j = 0; j < arity; ++j) {
                ClusNode child = new ClusNode();
                node.setChild(child, j);
                child.initClusteringStat(this.m_StatManager, this.m_Root.getClusteringStat(), subsets[j]);
                child.initTargetStat(this.m_StatManager, this.m_Root.getTargetStat(), subsets[j]);
                this.induceRandomForestRecursive(child, subsets[j], rnd);
            }
        } else {
            this.makeLeaf(node);
        }
    }
}

