/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.tdidt;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.FindBestTest;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSHelpers;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.main.settings.section.SettingsGeneric;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandomNonstatic;
import si.ijs.kt.clus.util.exception.ClusException;

public class DepthFirstInduce
extends ClusInductionAlgorithm {
    protected FindBestTest m_FindBestTest;
    protected FindBestTest m_Find_MinMax;
    protected ClusNode m_Root;
    protected static int SHOW_INDUCE_PROGRESS = 2;

    public DepthFirstInduce(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
        this.m_FindBestTest = new FindBestTest(this.getStatManager());
        this.m_Find_MinMax = new FindBestTest(this.getStatManager());
    }

    public DepthFirstInduce(ClusInductionAlgorithm other) {
        super(other);
        this.m_FindBestTest = new FindBestTest(this.getStatManager());
        this.m_Find_MinMax = new FindBestTest(this.getStatManager());
    }

    public DepthFirstInduce(ClusInductionAlgorithm other, ClusStatManager mgr, boolean parallelism) {
        super(other, mgr);
        this.m_FindBestTest = new FindBestTest(this.getStatManager());
        this.m_Find_MinMax = new FindBestTest(this.getStatManager());
    }

    public DepthFirstInduce(ClusInductionAlgorithm other, NominalSplit split) {
        super(other);
        this.m_FindBestTest = new FindBestTest(this.getStatManager(), split);
        this.m_Find_MinMax = new FindBestTest(this.getStatManager());
    }

    @Override
    public void initialize() throws ClusException, IOException {
        super.initialize();
    }

    public FindBestTest getFindBestTest() {
        return this.m_FindBestTest;
    }

    public CurrentBestTestAndHeuristic getBestTest() {
        return this.m_FindBestTest.getBestTest();
    }

    public boolean initSelectorAndStopCrit(ClusNode node, RowData data) {
        int max = this.getSettings().getConstraints().getTreeMaxDepth();
        if (max != -1 && node.getLevel() >= max) {
            return true;
        }
        this.m_Find_MinMax.initSelectorAndStopCrit(node.getClusteringStat(), data);
        if (node.getTargetStat().getTargetSumWeights() < 2.0 * this.getSettings().getModel().getMinimalWeight()) {
            return true;
        }
        return this.m_FindBestTest.initSelectorAndStopCrit(node.getClusteringStat(), data);
    }

    public ClusAttrType[] getDescriptiveAttributes(ClusRandomNonstatic rnd) {
        ClusAttrType[] selected;
        ClusSchema schema = this.getSchema();
        Settings sett = this.getSettings();
        if (!sett.getEnsemble().isEnsembleMode()) {
            return schema.getDescriptiveAttributes();
        }
        switch (sett.getEnsemble().getEnsembleMethod()) {
            case Bagging: {
                selected = schema.getDescriptiveAttributes();
                break;
            }
            case RForest: {
                ClusAttrType[] attrsAll = schema.getDescriptiveAttributes();
                selected = ClusEnsembleInduce.selectRandomSubspaces(attrsAll, schema.getSettings().getEnsemble().getNbRandomAttrSelected(), 3, rnd);
                break;
            }
            case RSubspaces: {
                selected = ClusEnsembleInduce.getRandomSubspaces();
                ClusEnsembleInduce.giveParallelisationWarning(ClusEnsembleInduce.ParallelTrap.DepthFirst_getDescriptiveAttributes);
                break;
            }
            case BagSubspaces: {
                ClusEnsembleInduce.giveParallelisationWarning(ClusEnsembleInduce.ParallelTrap.DepthFirst_getDescriptiveAttributes);
                selected = ClusEnsembleInduce.getRandomSubspaces();
                break;
            }
            case RFeatSelection: {
                ClusEnsembleInduce.giveParallelisationWarning(ClusEnsembleInduce.ParallelTrap.DepthFirst_getDescriptiveAttributes);
                ClusAttrType[] attrsAll1 = schema.getDescriptiveAttributes();
                selected = ClusEnsembleInduce.selectRandomSubspaces(attrsAll1, schema.getSettings().getEnsemble().getNbRandomAttrSelected(), 3, rnd);
                break;
            }
            case ExtraTrees: {
                ClusAttrType[] attrs_all = schema.getDescriptiveAttributes();
                selected = ClusEnsembleInduce.selectRandomSubspaces(attrs_all, schema.getSettings().getEnsemble().getNbRandomAttrSelected(), 3, rnd);
                break;
            }
            default: {
                selected = schema.getDescriptiveAttributes();
            }
        }
        return selected;
    }

    public void filterAlternativeSplits(ClusNode node, RowData data, RowData[] subsets) {
        CurrentBestTestAndHeuristic best = this.m_FindBestTest.getBestTest();
        int arity = node.getTest().updateArity();
        ArrayList<NodeTest> alternatives = best.getAlternativeBest();
        ArrayList<NodeTest> oppositeAlternatives = new ArrayList<NodeTest>();
        String alternativeString = new String();
        for (int k = 0; k < alternatives.size(); ++k) {
            NodeTest nt = alternatives.get(k);
            int altarity = nt.updateArity();
            if (altarity != arity) {
                alternatives.remove(k);
                --k;
                ClusLogger.info("Alternative split with different arity: " + nt.getString());
                continue;
            }
            int nbsubset0 = subsets[0].getNbRows();
            int[] indices = new int[nbsubset0];
            for (int m = 0; m < nbsubset0; ++m) {
                indices[m] = subsets[0].getTuple(m).getIndex();
            }
            boolean same = false;
            for (int l = 0; l < altarity; ++l) {
                RowData altrd = data.applyWeighted(nt, l);
                if (altrd.getNbRows() != nbsubset0) continue;
                int nbsame = 0;
                for (int m = 0; m < nbsubset0; ++m) {
                    if (altrd.getTuple(m).getIndex() != indices[m]) continue;
                    ++nbsame;
                }
                if (nbsame != nbsubset0) continue;
                same = true;
                if (l != 0) {
                    alternativeString = alternativeString + " and not(" + alternatives.get(k).toString() + ")";
                    alternatives.remove(k);
                    --k;
                    oppositeAlternatives.add(nt);
                    continue;
                }
                alternativeString = alternativeString + " and " + alternatives.get(k).toString();
            }
            if (same) continue;
            alternatives.remove(k);
            --k;
            ClusLogger.info("Alternative split with different ex in subsets: " + nt.getString());
        }
        node.setAlternatives(alternatives);
        node.setOppositeAlternatives(oppositeAlternatives);
        node.setAlternativesString(alternativeString);
    }

    public void makeLeaf(ClusNode node) {
        if (this.getSettings().getGeneral().getVerbose() >= SHOW_INDUCE_PROGRESS) {
            ClusLogger.info("Creating a leaf ...");
        }
        node.makeLeaf();
        if (this.getSettings().getTree().hasTreeOptimize(SettingsTree.TreeOptimizeValues.NoClusteringStats)) {
            node.setClusteringStat(null);
        }
    }

    public void induce(ClusNode node, RowData data, ClusRandomNonstatic rnd) throws Exception {
        boolean isGIS;
        if (this.getSettings().getEnsemble().getEnsembleROSAlgorithmType().equals((Object)SettingsEnsemble.EnsembleROSAlgorithmType.DynamicSubspaces)) {
            ClusROSModelInfo info = this.m_FindBestTest.getStatManager().getHeuristic().getClusteringAttributeWeights().getROSModelInfo();
            ClusLogger.fine(String.format("  ROS dynamic (Bag %s): %s => Node level: %s", info.getTreeNumber() + 1, info.getSubspaceString(), node.getLevel()));
            node.setROSModelInfo(info);
        }
        if (this.getSettings().getGeneral().getVerbose() >= SHOW_INDUCE_PROGRESS) {
            ClusLogger.fine("Depth " + node.getLevel() + ": inducing new node: " + data.getNbRows() + " examples");
        }
        if (rnd == null) {
            ClusEnsembleInduce.giveParallelisationWarning(ClusEnsembleInduce.ParallelTrap.StaticRandom);
        }
        if (this.initSelectorAndStopCrit(node, data)) {
            this.makeLeaf(node);
            return;
        }
        if (this.getSettings().getSSL().isSemiSupervisedMode() && this.getSettings().getTree().getMissingClusteringAttrHandling().equals((Object)SettingsTree.MissingClusteringAttributeHandlingType.EstimateFromParentNode)) {
            this.m_FindBestTest.setParentStatsToChildren();
        }
        ClusAttrType[] attrs = this.getDescriptiveAttributes(rnd);
        boolean bl = isGIS = !this.getSettings().getAttribute().isNullGIS();
        if (isGIS) {
            double globalMax = Double.NEGATIVE_INFINITY;
            double globalMin = Double.POSITIVE_INFINITY;
            this.m_Find_MinMax.resetMinMax();
            for (int i = 0; i < attrs.length; ++i) {
                ClusAttrType at = attrs[i];
                if (!(at instanceof NominalAttrType) || ((NominalAttrType)at).getNbValues() != 2) continue;
                this.m_Find_MinMax.rememberMinMax((NominalAttrType)at, data);
                if (this.m_Find_MinMax.hMaxB > globalMax) {
                    globalMax = this.m_Find_MinMax.hMaxB;
                }
                if (!(this.m_Find_MinMax.hMinB < globalMin)) continue;
                globalMin = this.m_Find_MinMax.hMinB;
            }
        }
        boolean isExtraTreesEnsemble = this.getSettings().getEnsemble().isEnsembleMode() && this.getSettings().getEnsemble().getEnsembleMethod().equals((Object)SettingsEnsemble.EnsembleMethod.ExtraTrees);
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = attrs[i];
            if (isGIS) {
                ClusStatistic.INITIALIZEPARTIALSUM = true;
                ClassificationStat.INITIALIZEPARTIALSUM = true;
                WHTDStatistic.INITIALIZEPARTIALSUM = true;
            }
            if (isExtraTreesEnsemble) {
                if (at.isNominal()) {
                    this.m_FindBestTest.findNominalExtraTree((NominalAttrType)at, data, rnd);
                    continue;
                }
                this.m_FindBestTest.findNumericExtraTree((NumericAttrType)at, data, rnd);
                continue;
            }
            if (at.isNominal()) {
                this.m_FindBestTest.findNominal((NominalAttrType)at, data, rnd);
                continue;
            }
            this.m_FindBestTest.findNumeric((NumericAttrType)at, data, rnd);
        }
        CurrentBestTestAndHeuristic best = this.m_FindBestTest.getBestTest();
        if (best.hasBestTest()) {
            int j;
            if (this.getSettings().getSSL().isSemiSupervisedMode() && this.getSettings().getTree().getMissingClusteringAttrHandling().equals((Object)SettingsTree.MissingClusteringAttributeHandlingType.EstimateFromParentNode)) {
                this.m_FindBestTest.setParentStatsToThis(node.getClusteringStat());
            }
            node.testToNode(best);
            if (this.getSettings().getGeneral().getVerbose() >= SHOW_INDUCE_PROGRESS) {
                ClusLogger.info("Test: " + node.getTestString() + " -> " + best.getHeuristicValue());
            }
            int arity = node.updateArity();
            NodeTest test = node.getTest();
            RowData[] subsets = new RowData[arity];
            for (j = 0; j < arity; ++j) {
                subsets[j] = data.applyWeighted(test, j);
            }
            if (this.getSettings().getTree().showAlternativeSplits()) {
                this.filterAlternativeSplits(node, data, subsets);
            }
            if (node != this.m_Root && this.getSettings().getTree().hasTreeOptimize(SettingsTree.TreeOptimizeValues.NoInodeStats)) {
                node.setClusteringStat(null);
                node.setTargetStat(null);
            }
            for (j = 0; j < arity; ++j) {
                ClusNode child = new ClusNode();
                node.setChild(child, j);
                child.initClusteringStat(this.m_StatManager, this.m_Root.getClusteringStat(), subsets[j]);
                child.initTargetStat(this.m_StatManager, this.m_Root.getTargetStat(), subsets[j]);
                if (this.getSettings().getSSL().isSemiSupervisedMode() && (this.getSettings().getTree().getMissingClusteringAttrHandling().equals((Object)SettingsTree.MissingClusteringAttributeHandlingType.EstimateFromParentNode) || this.getSettings().getTree().getMissingTargetAttrHandling().equals((Object)SettingsTree.MissingTargetAttributeHandlingType.ParentNode))) {
                    child.getClusteringStat().setParentStat(node.getClusteringStat());
                    child.getTargetStat().setParentStat(node.getTargetStat());
                }
                if (this.getSettings().getEnsemble().isEnsembleROSEnabled() && this.getSettings().getEnsemble().getEnsembleROSAlgorithmType().equals((Object)SettingsEnsemble.EnsembleROSAlgorithmType.DynamicSubspaces)) {
                    ClusROSModelInfo nodeROSModelInfo = node.getROSModelInfo();
                    int sizeOfSubspace = nodeROSModelInfo.getSizeOfSubspace();
                    if (nodeROSModelInfo.isRandom() && !nodeROSModelInfo.isRandomPerTree()) {
                        sizeOfSubspace = -1;
                    }
                    HashMap<Integer, Integer> newSubspace = ClusROSHelpers.generateSubspace(this.getStatManager().getSchema(), sizeOfSubspace, this.getSettings().getEnsemble().getEnsembleROSAlgorithmType(), nodeROSModelInfo.getTreeNumber());
                    ClusROSModelInfo childROSModelInfo = nodeROSModelInfo.initWithNewSubspace(newSubspace);
                    nodeROSModelInfo.addChild(childROSModelInfo);
                    child.setROSModelInfo(childROSModelInfo);
                    this.m_FindBestTest.getStatManager().getHeuristic().getClusteringAttributeWeights().setROSModelInfo(childROSModelInfo);
                }
                this.induce(child, subsets[j], rnd);
            }
        } else {
            this.makeLeaf(node);
        }
        if (this.getSettings().getGeneral().getVerbose() >= SHOW_INDUCE_PROGRESS) {
            ClusLogger.finer("Depth " + node.getLevel() + ": node finished.");
        }
    }

    @Deprecated
    public void rankFeatures(ClusNode node, RowData data, ClusRandomNonstatic rnd) throws Exception {
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream("ranking.csv")));
        ClusAttrType[] attrs = this.getDescriptiveAttributes(rnd);
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = attrs[i];
            this.initSelectorAndStopCrit(node, data);
            if (at instanceof NominalAttrType) {
                this.m_FindBestTest.findNominal((NominalAttrType)at, data, null);
            } else {
                this.m_FindBestTest.findNumeric((NumericAttrType)at, data, null);
            }
            CurrentBestTestAndHeuristic cbt = this.m_FindBestTest.getBestTest();
            if (!cbt.hasBestTest()) continue;
            NodeTest test = cbt.updateTest();
            wrt.print(cbt.m_BestHeur);
            wrt.print(",\"" + at.getName() + "\"");
            wrt.println(",\"" + test + "\"");
        }
        wrt.close();
    }

    public void initSelectorAndSplit(ClusStatistic stat) throws ClusException {
        this.m_FindBestTest.initSelectorAndSplit(stat);
        this.m_Find_MinMax.initSelectorAndSplit(stat);
    }

    public void setInitialData(ClusStatistic stat, RowData data) throws ClusException {
        this.m_FindBestTest.setInitialData(stat, data);
        this.m_Find_MinMax.setInitialData(stat, data);
    }

    public void cleanSplit() {
        this.m_FindBestTest.cleanSplit();
    }

    public ClusNode induceSingleUnpruned(RowData data, ClusRandomNonstatic rnd) throws Exception {
        this.m_Root = null;
        do {
            this.m_Root = new ClusNode();
            this.m_Root.initClusteringStat(this.m_StatManager, data);
            this.m_Root.initTargetStat(this.m_StatManager, data);
            if (!this.m_Schema.getSettings().getEnsemble().isEnsembleMode()) {
                this.m_Root.getClusteringStat().showRootInfo();
            }
            this.initSelectorAndSplit(this.m_Root.getClusteringStat());
            this.setInitialData(this.m_Root.getClusteringStat(), data);
            data.addIndices();
            this.induce(this.m_Root, data, rnd);
        } while (SettingsGeneric.EXACT_TIME);
        this.m_Root.afterInduce(this.m_StatManager);
        this.cleanSplit();
        return this.m_Root;
    }

    public ClusModel induceSingleUnpruned(ClusRun cr, ClusRandomNonstatic rnd) throws Exception {
        return this.induceSingleUnpruned((RowData)cr.getTrainingSet(), rnd);
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws Exception {
        if (this.getSettings().getEnsemble().isEnsembleMode() && this.getSettings().getEnsemble().getNumberOfThreads() != -1) {
            ClusLogger.info(String.format("Potential WARNING:\nIt seems that you are trying to build an ensemble in parallel.\n If this is not the case, ignore this message. Otherwise: The chosen number of threads (%d) is not equal to 1, and the method\ninduceSingleUnpruned(ClusRun cr) is not appropriate for parallelism (the results might not be reproducible).\nThe method induceSingleUnpruned(RowData data, ClusRandomNonstatic rnd) should be used instead.", this.getSettings().getEnsemble().getNumberOfThreads()));
        }
        return this.induceSingleUnpruned((RowData)cr.getTrainingSet(), null);
    }
}

