/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.tdidt;

import java.io.IOException;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.ClusInductionAlgorithmType;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.rules.ClusRulesFromTree;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.ConstraintDFInduce;
import si.ijs.kt.clus.algo.tdidt.DepthFirstInduce;
import si.ijs.kt.clus.algo.tdidt.DepthFirstInduceSparse;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.bestfirst.BestFirstInduce;
import si.ijs.kt.clus.ext.ilevelc.ILevelCInduce;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsOutput;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.pruning.PruneTree;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgs;

public class ClusDecisionTree
extends ClusInductionAlgorithmType {
    public static final int LEVEL_WISE = 0;
    public static final int DEPTH_FIRST = 1;

    public ClusDecisionTree(Clus clus) {
        super(clus);
    }

    @Override
    public void printInfo() {
        ClusLogger.info("TDIDT");
        ClusLogger.info("Heuristic: " + this.getStatManager().getHeuristicName());
    }

    @Override
    public ClusInductionAlgorithm createInduce(ClusSchema schema, Settings sett, CMDLineArgs cargs) throws ClusException, IOException {
        if (sett.getConstraints().hasConstraintFile()) {
            boolean fillin = cargs.hasOption("fillin");
            return new ConstraintDFInduce(schema, sett, fillin);
        }
        if (sett.getILevelC().isSectionILevelCEnabled()) {
            return new ILevelCInduce(schema, sett);
        }
        if (schema.isSparse()) {
            return new DepthFirstInduceSparse(schema, sett);
        }
        switch (sett.getTree().getInductionOrder()) {
            case DepthFirst: {
                return new DepthFirstInduce(schema, sett);
            }
        }
        return new BestFirstInduce(schema, sett);
    }

    public static ClusModel induceDefault(ClusRun cr) throws ClusException, InterruptedException {
        ClusNode node = new ClusNode();
        RowData data = (RowData)cr.getTrainingSet();
        node.initTargetStat(cr.getStatManager(), data);
        node.computePrediction();
        node.makeLeaf();
        return node;
    }

    public void convertToRules(ClusRun cr, ClusModelInfo model) throws ClusException, IOException, InterruptedException {
        ClusNode tree_root = (ClusNode)model.getModel();
        ClusRulesFromTree rft = new ClusRulesFromTree(true, this.getSettings().getTree().rulesFromTree());
        ClusRuleSet rule_set = null;
        boolean compDis = this.getSettings().getRules().computeDispersion();
        rule_set = rft.constructRules(cr, tree_root, this.getStatManager(), compDis, this.getSettings().getRules().getRulePredictionMethod());
        rule_set.addDataToRules((RowData)cr.getTrainingSet());
        ClusModelInfo rules_info = cr.addModelInfo("Rules-" + model.getName());
        rules_info.setModel(rule_set);
    }

    @Override
    public void pruneAll(ClusRun cr) throws ClusException, IOException, InterruptedException {
        ClusNode orig = (ClusNode)cr.getModel(1);
        orig.numberTree();
        PruneTree pruner = this.getStatManager().getTreePruner(cr.getPruneSet());
        pruner.setTrainingData((RowData)cr.getTrainingSet());
        int nb = pruner.getNbResults();
        for (int i = 0; i < nb; ++i) {
            ClusModelInfo pruned_info = pruner.getPrunedModelInfo(i, orig);
            cr.addModelInfo(pruned_info);
        }
    }

    @Override
    public final ClusModel pruneSingle(ClusModel orig, ClusRun cr) throws ClusException, InterruptedException {
        ClusNode pruned = (ClusNode)((ClusNode)orig).cloneTree();
        PruneTree pruner = this.getStatManager().getTreePruner(cr.getPruneSet());
        pruner.setTrainingData((RowData)cr.getTrainingSet());
        pruner.prune(pruned);
        return pruned;
    }

    @Override
    public void postProcess(ClusRun cr) throws ClusException, IOException, InterruptedException {
        if (!this.getSettings().getTree().rulesFromTree().equals((Object)SettingsOutput.ConvertRules.No)) {
            ClusModelInfo model = cr.getModelInfoFallback(2, 1);
            this.convertToRules(cr, model);
        }
    }
}

